#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
$attrList = $deployed.attributes.split([Environment]::NewLine)

Write-Host "attrList $attrList"
Foreach ($attr IN $attrList) {
    Write-Host "attr $attr"
    if ($attr.Contains("~")) {
        $tokens = $attr.split("~")
        $name = $tokens[0]
        $value = $tokens[1]
        Write-Host "Setting property $tokens"
        if($deployed.psPath -ne $null -and $deployed.location -ne $null) {
            Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -NameValue $tokens"
            Set-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Location $deployed.location -Name $name -Value $value
        } elseif ($deployed.psPath -ne $null) {
            Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -NameValue $tokens"
            Set-WebConfigurationProperty -Filter $deployed.filter -PSPath $deployed.psPath -Name $name -Value $value
        } elseif ($deployed.location -ne $null) {
            Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -NameValue $tokens"
            Set-WebConfigurationProperty -Filter $deployed.filter -Location $deployed.location -Name $name -Value $value
        } else {
            Write-Host "Command executed to Set WebConfigurationProperty -Filter $deployed.filter -NameValue $tokens"
            Set-WebConfigurationProperty -Filter $deployed.filter -Name $name -Value $value
        }
        Write-Host "Completed setting property $name and value $value"
    }
}
