#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Remove old web content if it's still there
if (Test-Path $deployed.targetPath) {
	Write-Host "Removing old web content from [$($deployed.targetPath)]."
	Get-ChildItem $deployed.targetPath -Recurse | Sort-Object -Property FullName -Descending | Remove-Item -Force | Out-Null
	Remove-Item $deployed.targetPath -Force | Out-Null
}

# Check for uncaught failure - if web content removal failed for some reason, throw an error
if (Test-Path $deployed.targetPath) {
    $Content_Removal_Error=[string]"Existing web content in the provided path was not successfully removed. Please check that there are no open handles to existing web content and retry."
    Throw $Content_Removal_Error
}

# Copy new web content
Write-Host "Copying web content to [$($deployed.targetPath)]."
Copy-Item -Recurse -Force $deployed.file $deployed.targetPath
