#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
#Construct attribute values in format required for Remove-WebConfigurationProperty
Write-Host "Remove attribute started"
$attrList = $deployed.attributes.split([Environment]::NewLine)

Foreach ($attr IN $attrList) {
    if ($attr.Contains("~")) {
        $tokens = $attr.split("~")
        $modifiedFilter = $deployed.filter + "/@" + $tokens[0]
        if($deployed.psPath -ne $null -and $deployed.location -ne $null) {
            Write-Host "Command executed to Clear WebConfiguration -Filter $modifiedFilter -PSPath $deployed.psPath -Location $deployed.location"
            $collectionElement = Clear-WebConfiguration -Filter $modifiedFilter -PSPath $deployed.psPath -Location $deployed.location
        } elseif ($deployed.psPath -ne $null) {
            Write-Host "Command executed to Remove WebConfigurationProperty -Filter $modifiedFilter -PSPath $deployed.psPath"
            $collectionElement = Clear-WebConfiguration -Filter $modifiedFilter -PSPath $deployed.psPath
        } elseif ($deployed.location -ne $null) {
            Write-Host "Command executed to Remove WebConfigurationProperty -Filter $modifiedFilter -Location $deployed.location"
            $collectionElement = Clear-WebConfiguration -Filter $modifiedFilter -Location $deployed.location
        } else {
            Write-Host "Command executed to Remove WebConfigurationProperty -Filter $modifiedFilter"
            $collectionElement = Clear-WebConfiguration -Filter $modifiedFilter
        }
    }
}
Write-Host "Remove attribute completed"
