#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided virtual directory path or use the deployed name.
$virtualDirectoryPath = if($deployed.virtualDirectoryPath) { $deployed.virtualDirectoryPath } else { $deployed.name }

# Verify virtual directory path and website name are not being changed.
if($previousDeployed) {
    $previousVirtualDirectoryPath = if($previousDeployed.virtualDirectoryPath) { $previousDeployed.virtualDirectoryPath } else { $previousDeployed.name }
    if($virtualDirectoryPath -ne $previousVirtualDirectoryPath) {
        Write-Host "Renaming a virtual directory is not supported. Undeploy and deploy the virtual directory instead."
        Exit 1
    }

    if($deployed.websiteName -ne $previousDeployed.websiteName) {
        Write-Host "Moving a virtual directory is not supported. Undeploy and deploy the virtual directory instead."
        Exit 1
    }
}

# Verify website exists.
$website = getWebsite $deployed.websiteName
if (!$website) {
    throw "Website [$($deployed.websiteName)] does not exist."
}

# Create physical path if it doesn't exist yet.
if (!(Test-Path $deployed.physicalPath)) {
    Write-Host "Creating virtual directory physical path [$($deployed.physicalPath)]."
    if(!(New-Item $deployed.physicalPath -Type Directory -Force)) {
        Write-Host "Cannot create directory [$($deployed.physicalPath)]."
        Exit 1
    }
}

# Check whether virtual directory already exists and then either retrieve or create it.
$virtualDirectory = getVirtualDirectory $website $virtualDirectoryPath
if ($virtualDirectory) {
    Write-Host "Modifying existing virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]."
} else {
    Write-Host "Creating new virtual directory [$virtualDirectoryPath] in website [$($deployed.websiteName)]."
    $virtualDirectory = ([ADSI]"IIS://localhost/$($website.Name)/ROOT").Create("IIsWebVirtualDir", $virtualDirectoryPath)
}

# Set virtual directory properties.
$virtualDirectory.Put("Path", $deployed.physicalPath)
$virtualDirectory.Put("DefaultDoc", "Default.aspx,Default.htm,Default.asp,index.htm")

# Save virtual directory.
$virtualDirectory.SetInfo()
