#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Destroy application pool, if it exists.
$appPoolPath = "IIS:\AppPools\$applicationPoolName";
if (Test-Path $appPoolPath) {
    Write-Host "Destroying application pool [$applicationPoolName]."
    Get-ChildItem $appPoolPath -Recurse | Sort-Object -Property FullName -Descending | Remove-Item -Force | Out-Null
} else {
    Write-Host "Application pool [$applicationPoolName] has already been destroyed."
}
