#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided website name or use the deployed name.
$websiteName = if($deployed.websiteName) { $deployed.websiteName } else { $deployed.name }

# Stop website, if it exists and has not already been stopped.
$websitePath = "IIS:\Sites\$websiteName"
if (!(Test-Path $websitePath)) {
    Write-Host "Website [$websiteName] does not exist."
    Exit 1
} elseif((Get-Item $websitePath).State -eq "Stopped") {
    Write-Host "Website [$websiteName] has already been stopped."
} else {
    Write-Host "Stopping website [$websiteName]."
    Stop-Website -Name $websiteName | Out-Null
    # Stop-Website is aysnchronous, need to verify if app is actually stopped
    $currentRetry = 1;
    $success = $false;
    do {
        $status = (Get-Item $websitePath).State
        if ($status -eq "Stopped"){
            Write-Host "Website [$websiteName] has stopped."
                $success = $true;
        }
        Start-Sleep -s $deployed.sleepBetweenChecks
        $currentRetry = $currentRetry + 1;
    }
    while (!$success -and $currentRetry -le $deployed.numberOfChecks)
    if ($currentRetry -eq $deployed.numberOfChecks -And $success -eq $false) {
        Write-Host "Website [$websiteName] is still not stopped. Please retry."
        Exit 1
    }
}

