#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

# Get provided application pool name or use the deployed name.
$applicationPoolName = if($deployed.applicationPoolName) { $deployed.applicationPoolName } else { $deployed.name }

# Stop application pool, if it exists and has not already been stopped.
$applicationPoolPath = "IIS:\AppPools\$applicationPoolName"
if (!(Test-Path $applicationPoolPath)) {
    Write-Host "Application pool [$applicationPoolName] does not exist."
    Exit 1
} elseif((Get-Item $applicationPoolPath).State -eq "Stopped") {
    Write-Host "Application pool [$applicationPoolName] has already been stopped."
} else {
    Write-Host "Stopping application pool [$applicationPoolName]."
    Stop-WebAppPool -Name $applicationPoolName | Out-Null
    # Stop-WebAppPool is aysnchronous, need to verify if appPool is actually stopped
    $currentRetry = 1;
    $success = $false;
    do {
        $status = (Get-Item $applicationPoolPath).State
        if ($status -eq "Stopped"){
            Write-Host "Application pool [$applicationPoolName] has stopped."
                $success = $true;
        }
        Start-Sleep -s $deployed.sleepBetweenChecks
        $currentRetry = $currentRetry + 1;
    }
    while (!$success -and $currentRetry -le $deployed.numberOfChecks)
    if ($currentRetry -eq $deployed.numberOfChecks -And $success -eq $false) {
        Write-Host "Application pool [$applicationPoolName] is still not stopped. Please retry."
        Exit 1
    }
}
