logOutput("Creating jms resource")

jndiName = deployed.getProperty("jndiName")

# Due to glassfish bug we first create it on 'server'
targetName = 'server' if deployed.container.targetName == 'domain' else deployed.container.targetName

options = dict(exposedPropertiesMap(deployed, 'General', ignoredProps = set(['jndiName'])).items() + [('restype', deployed.getProperty('restype'))])
properties = exposedPropertiesMap(deployed, "Additional Properties")

executeCmd(Create('create-jms-resource', options, properties, jndiName).build())

# And then delete so that it left only in domain
if (deployed.container.targetName == 'domain'):
    executeCmd(Destroy('delete-resource-ref', targetName, jndiName).build())


logOutput("Done")