/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.session;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.xebialabs.deployit.plugin.glassfish.session.CliSession;
import com.xebialabs.deployit.plugin.glassfish.session.Response;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveSession
implements CliSession {
    private int idleResponseTimeInSeconds = 60;
    private OverthereProcess process;
    private OverthereConnection connection;
    private Pattern promptPattern;
    private Host host;
    private String driverScriptContent;
    private String driverScriptName;
    private SimpleTimeLimiter limiter = SimpleTimeLimiter.create((ExecutorService)Executors.newCachedThreadPool());
    private CliSession timeoutEnabledSession;
    private static final Logger logger = LoggerFactory.getLogger(InteractiveSession.class);

    public InteractiveSession(Host host, String driverScriptContent, Pattern promptPattern) {
        this.host = host;
        this.driverScriptContent = driverScriptContent;
        this.promptPattern = promptPattern;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.process != null;
    }

    @Override
    public void disconnect() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void connect() {
        this.connect(true);
    }

    private void connect(boolean enableTimeout) {
        this.disconnect();
        this.connection = this.host.getConnection();
        this.process = this.connection.startProcess(this.setupCmdLine());
        final StringBuilder outputBuffer = new StringBuilder();
        if (!enableTimeout) {
            this.waitForSessionToStart(outputBuffer);
            return;
        }
        try {
            this.limiter.callWithTimeout((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    InteractiveSession.this.waitForSessionToStart(outputBuffer);
                    return null;
                }
            }, (long)this.idleResponseTimeInSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeout) {
            throw new RuntimeIOException("Failed to start interactive session due to time out. Output:\n " + outputBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CmdLine setupCmdLine() {
        OverthereFile driverFile = this.uploadDriver();
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(driverFile.getPath());
        return cmdLine;
    }

    private OverthereFile uploadDriver() {
        OverthereFile driverFile = Strings.isNullOrEmpty((String)this.driverScriptName) ? this.connection.getTempFile(this.driverScriptName) : this.connection.getTempFile("glassfish", "driver");
        OverthereUtils.write((byte[])this.driverScriptContent.getBytes(), (OverthereFile)driverFile);
        driverFile.setExecutable(true);
        return driverFile;
    }

    @Override
    public Response execute(final String command) {
        final ArrayList outputBuffer = Lists.newArrayList();
        try {
            this.limiter.callWithTimeout((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    InteractiveSession.this.doExecute(command, outputBuffer);
                    return null;
                }
            }, (long)this.idleResponseTimeInSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeout) {
            return new Response(1, outputBuffer, "Failed to execute command [" + command + "] due to time out.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Response(0, outputBuffer);
    }

    private void doExecute(String command, List<String> outputBuffer) {
        if (!this.isConnected()) {
            this.connect(false);
        }
        this.writeCommandToStandardInput(command);
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(this.process.getStdout()));
        while (true) {
            Matcher matcher;
            String line = null;
            try {
                line = inputStream.readLine();
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Failed to execute command [" + command + "] due to time out. Output:\n " + outputBuffer, (Throwable)exc);
            }
            if (line == null || (matcher = this.promptPattern.matcher(line)).matches()) break;
            outputBuffer.add(line);
        }
    }

    private void writeCommandToStandardInput(String command) {
        String finalCommand = command.charAt(command.length() - 1) == '\n' ? command : command + "\n";
        OutputStream stdin = this.process.getStdin();
        try {
            stdin.write(finalCommand.getBytes());
            stdin.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private void waitForSessionToStart(StringBuilder outputBuffer) {
        Matcher matcher;
        InputStream inputStream = this.process.getStdout();
        do {
            int cInt = 0;
            try {
                cInt = inputStream.read();
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Failed to start interactive session", (Throwable)exc);
            }
            if (cInt == -1) {
                this.exitBecauseProcessFailedToStart(this.process.getStderr());
            }
            outputBuffer.append((char)cInt);
        } while (!(matcher = this.promptPattern.matcher(outputBuffer)).matches());
    }

    private void exitBecauseProcessFailedToStart(InputStream stderr) {
        int exitCode = -1;
        String errMsg = "";
        try {
            exitCode = this.process.waitFor();
            if (stderr.available() > 0) {
                errMsg = new String(ByteStreams.toByteArray((InputStream)stderr));
            }
        }
        catch (InterruptedException exc) {
            logger.error("Interrupted while waiting for " + this.process + " to complete");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            logger.error("Failed to read error stream.", (Throwable)e);
        }
        throw new RuntimeIOException("Failed to start interactive session with exit code " + exitCode + ". " + errMsg);
    }

    public Pattern getPromptPattern() {
        return this.promptPattern;
    }

    public int getIdleResponseTimeInSeconds() {
        return this.idleResponseTimeInSeconds;
    }

    public void setIdleResponseTimeInSeconds(int idleResponseTimeInSeconds) {
        this.idleResponseTimeInSeconds = idleResponseTimeInSeconds;
        this.timeoutEnabledSession = null;
    }

    public String getDriverScriptName() {
        return this.driverScriptName;
    }

    public void setDriverScriptName(String driverScriptName) {
        this.driverScriptName = driverScriptName;
    }
}

