/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.glassfish.constants.ContainerRestartStrategy;
import com.xebialabs.deployit.plugin.glassfish.constants.DeployedRestartStrategy;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.deployed.DeltaWrapper;
import com.xebialabs.deployit.plugin.glassfish.step.BaseStep;
import com.xebialabs.deployit.plugin.glassfish.step.CliInspectionStep;
import com.xebialabs.deployit.plugin.glassfish.step.StepFactory;
import java.util.HashMap;
import java.util.List;

@Metadata(virtual=true, description="Base for all deployed that utilize the Glassfish Cli for configuration")
public class CliManagedDeployed<D extends Deployable, C extends CliManagedContainer>
extends BaseDeployed<D, C> {
    @Property(hidden=true, defaultValue="60", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="60", description="The order of the step in the step list for the modify operation.")
    private int modifyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the noop operation.")
    private int noopOrder;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String noopVerb;
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the noop operation.")
    private String noopScript;
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="List of python library scripts that should be automatically loaded when using a Glassfish CLI script.")
    private List<String> libraryScripts = Lists.newArrayList();
    @Property(hidden=true, required=false, description="Python script invoked to start a Java EE artifact or Java EE resource")
    private String startScript;
    @Property(hidden=true, defaultValue="Start", description="The word that is used to prefix a step description for the start operation.")
    private String startVerb;
    @Property(hidden=true, defaultValue="90", description="The order in which a start step will be executed.")
    private int startOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop a Java EE artifact or Java EE resource")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop", description="The word that is used to prefix a step description for the stop operation.")
    private String stopVerb;
    @Property(hidden=true, defaultValue="10", description="The order in which a stop step will be executed.")
    private int stopOrder;
    @Property(defaultValue="NONE", hidden=true, category="Restart Strategy", description="The logical stop/start sequence for the container affected by the deployed. STOP_START : stop container, undeploy, deploy, start container. RESTART : undeploy, deploy, stop container, start container.")
    private ContainerRestartStrategy containerRestartStrategy = ContainerRestartStrategy.NONE;
    @Property(defaultValue="NONE", hidden=true, category="Restart Strategy", description="The logical stop/start sequence for the deployed. STOP_START : stop, undeploy, deploy, start. STOP: stop, undeploy, deploy. START: undeploy, deploy, start.")
    private DeployedRestartStrategy restartStrategy = DeployedRestartStrategy.STOP_START;
    @Property(defaultValue="false", hidden=true, category="Restart Strategy", description="When true, the restart strategy is apply for a NOOP operation")
    private boolean applyRestartStrategyOnNoop;

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta) {
        return this.addStep(stepFactory, ctx, script, order, verb, delta, true);
    }

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta, boolean checkpoint) {
        return this.addStep(stepFactory, ctx, script, order, verb, delta, checkpoint, delta.getOperation());
    }

    protected boolean addStep(StepFactory stepFactory, DeploymentPlanningContext ctx, String script, int order, String verb, Delta delta, boolean checkpoint, Operation operation) {
        if (!Strings.isNullOrEmpty((String)script)) {
            HashMap<String, Object> pyCtx = this.createPythonVars();
            pyCtx.put("delta", new DeltaWrapper(delta));
            pyCtx.put("deployedApplication", ctx.getDeployedApplication());
            BaseStep step = stepFactory.withLibraries(this.libraryScripts).createStep(script, order, pyCtx, this.getDescription(verb), (CliManagedContainer)this.getContainer());
            if (checkpoint) {
                ctx.addStepWithCheckpoint((Step)step, delta, operation);
            } else {
                ctx.addStep((Step)step);
            }
            return true;
        }
        return false;
    }

    protected HashMap<String, Object> createPythonVars() {
        HashMap pyCtx = Maps.newHashMap();
        pyCtx.put("deployed", this);
        pyCtx.put("container", this.getContainer());
        return pyCtx;
    }

    public String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((CliManagedContainer)this.getContainer()).getName());
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        if (!Strings.nullToEmpty((String)this.getInspectScript()).trim().isEmpty()) {
            String desc = "Inspect " + this.getName() + " in container " + ((CliManagedContainer)this.getContainer()).getId();
            CliInspectionStep step = new CliInspectionStep(this.getInspectScript(), 0, this.createPythonVars(), desc, (CliManagedContainer)this.getContainer());
            step.setAdditionalLibraries(this.libraryScripts);
            ctx.addStep((Step)step);
        }
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        this.executeCreateWithStepFactory(StepFactory.deploymentStepFactory(), ctx, delta);
    }

    protected void executeCreateWithStepFactory(StepFactory stepFactory, DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        deployed.addStep(stepFactory, ctx, this.getCreateScript(), this.getCreateOrder(), this.getCreateVerb(), delta, true, Operation.CREATE);
        this.addStartStep(ctx);
    }

    private void addStartStep(DeploymentPlanningContext ctx) {
        if (this.restartStrategy == DeployedRestartStrategy.STOP_START || this.restartStrategy == DeployedRestartStrategy.START) {
            this.addStep(StepFactory.deploymentStepFactory(), ctx, this.getStartScript(), this.getStartOrder(), this.getStartVerb(), null, false);
        }
    }

    private void addStopStep(DeploymentPlanningContext ctx) {
        if (this.restartStrategy == DeployedRestartStrategy.STOP_START || this.restartStrategy == DeployedRestartStrategy.STOP) {
            this.addStep(StepFactory.deploymentStepFactory(), ctx, this.getStopScript(), this.getStopOrder(), this.getStopVerb(), null, false);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getPrevious();
        deployed.addStep(StepFactory.deploymentStepFactory(), ctx, this.getDestroyScript(), this.getDestroyOrder(), this.getDestroyVerb(), delta, true, Operation.DESTROY);
        deployed.addStopStep(ctx);
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        deployed.addStep(StepFactory.deploymentStepFactory(), ctx, this.getNoopScript(), this.getNoopOrder(), this.getNoopVerb(), delta, false);
        if (this.applyRestartStrategyOnNoop) {
            this.addStartStep(ctx);
            this.addStopStep(ctx);
        }
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        CliManagedDeployed deployed = (CliManagedDeployed)delta.getDeployed();
        boolean added = deployed.addStep(StepFactory.deploymentStepFactory(), ctx, this.getModifyScript(), this.getModifyOrder(), this.getModifyVerb(), delta, true, Operation.MODIFY);
        if (added) {
            this.addStartStep(ctx);
            this.addStopStep(ctx);
        } else {
            CliManagedDeployed previousDeployed = (CliManagedDeployed)delta.getPrevious();
            previousDeployed.restartStrategy = deployed.restartStrategy;
            previousDeployed.containerRestartStrategy = deployed.containerRestartStrategy;
            previousDeployed.executeDestroy(ctx, delta);
            deployed.executeCreate(ctx, delta);
        }
    }

    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public void setLibraryScripts(List<String> libraryScripts) {
        this.libraryScripts = libraryScripts;
    }

    public String getCreateScript() {
        return this.createScript;
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }

    public String getNoopScript() {
        return this.noopScript;
    }

    public void setNoopScript(String noopScript) {
        this.noopScript = noopScript;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    public int getNoopOrder() {
        return this.noopOrder;
    }

    public void setNoopOrder(int noopOrder) {
        this.noopOrder = noopOrder;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public void setCreateVerb(String createVerb) {
        this.createVerb = createVerb;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public void setModifyVerb(String modifyVerb) {
        this.modifyVerb = modifyVerb;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public void setDestroyVerb(String destroyVerb) {
        this.destroyVerb = destroyVerb;
    }

    public String getNoopVerb() {
        return this.noopVerb;
    }

    public void setNoopVerb(String noopVerb) {
        this.noopVerb = noopVerb;
    }

    public String getInspectScript() {
        return this.inspectScript;
    }

    public void setInspectScript(String inspectScript) {
        this.inspectScript = inspectScript;
    }

    public String getStartScript() {
        return this.startScript;
    }

    public void setStartScript(String startScript) {
        this.startScript = startScript;
    }

    public String getStartVerb() {
        return this.startVerb;
    }

    public void setStartVerb(String startVerb) {
        this.startVerb = startVerb;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public void setStartOrder(int startOrder) {
        this.startOrder = startOrder;
    }

    public String getStopScript() {
        return this.stopScript;
    }

    public void setStopScript(String stopScript) {
        this.stopScript = stopScript;
    }

    public String getStopVerb() {
        return this.stopVerb;
    }

    public void setStopVerb(String stopVerb) {
        this.stopVerb = stopVerb;
    }

    public int getStopOrder() {
        return this.stopOrder;
    }

    public void setStopOrder(int stopOrder) {
        this.stopOrder = stopOrder;
    }

    public ContainerRestartStrategy getContainerRestartStrategy() {
        return this.containerRestartStrategy;
    }

    public void setContainerRestartStrategy(ContainerRestartStrategy containerRestartStrategy) {
        this.containerRestartStrategy = containerRestartStrategy;
    }

    public DeployedRestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    public void setRestartStrategy(DeployedRestartStrategy restartStrategy) {
        this.restartStrategy = restartStrategy;
    }

    public boolean isApplyRestartStrategyOnNoop() {
        return this.applyRestartStrategyOnNoop;
    }

    public void setApplyRestartStrategyOnNoop(boolean applyRestartStrategyOnNoop) {
        this.applyRestartStrategyOnNoop = applyRestartStrategyOnNoop;
    }
}

