package com.xebialabs.deployit.plugin.glassfish.step;

import com.xebialabs.deployit.plugin.api.flow.*;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.overthere.OverthereFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

@SuppressWarnings("serial")
public class CliStageableStep extends BaseStep implements StageableStep {
    private static final Logger logger = LoggerFactory.getLogger(CliStageableStep.class);
    private final Artifact artifact;
    private StagedFile stagedFile;

    public CliStageableStep(final Artifact artifact, final String script, final int order, final Map<String, Object> pythonContext,
                            final String description, final CliManagedContainer container) {
        super(script, order, pythonContext, description, container);
        this.artifact = artifact;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }


    @Override
    public void requestStaging(final StagingContext ctx) {
        if(artifact != null){
            stagedFile = ctx.stageArtifact(artifact, getContainer().getHost());
        }
    }

    @Override
    public OverthereFile uploadToWorkingDirectory(final OverthereFile content, final String fileName) {
        OverthereFile fileToCopy = content;
        if(stagedFile != null){
            fileToCopy = stagedFile.get(getRemoteConnection(), getCtx());
        }
        return super.uploadToWorkingDirectory(fileToCopy, fileName);
    }

    @Override
    protected Logger logger() {
        return logger;
    }

}
