/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.step;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.step.CliDeploymentStep;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StepMetadata(name="glassfish-cli")
public class GlassfishCliStep
extends CalculatedStep
implements StageableStep {
    protected static final Logger logger = LoggerFactory.getLogger(GlassfishCliStep.class);
    @StepParameter(description="CLI managed container (Cluster, Server or Domain) to execute the python script", calculated=true)
    private CliManagedContainer container;
    @StepParameter(description="Path to the python script to be executed")
    private String script;
    @StepParameter(description="Dictionary that represent context available to the python script", required=false, calculated=true)
    private Map<String, Object> pythonContext = new HashMap<String, Object>();
    @StepParameter(description="List of python library scripts that should be automatically loaded when using a Glassfish CLI script.", required=false, calculated=true)
    private List<String> additionalLibraries = Lists.newArrayList();
    @StepParameter(description="If true, artifacts from the python context will be uploaded to the target host and available to the script as <bindingName>.file (of type OverthereFile). Defaults to true. If set to false it will prevent staging.", required=false)
    private Boolean uploadArtifactsInPythonContext = true;
    private CliDeploymentStep cliStep;

    @RulePostConstruct
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        this.pythonContext = ContextHelper.defaultContext((StepPostConstructContext)ctx, this.pythonContext);
        this.container = this.calculateTargetContainer(ctx);
        this.cliStep = new CliDeploymentStep(this.script, this.getOrder(), this.pythonContext, this.getDescription(), this.container);
        this.cliStep.setAdditionalLibraries(this.additionalLibraries);
    }

    private CliManagedContainer calculateTargetContainer(StepPostConstructContext ctx) {
        CliManagedContainer targetcontainer = this.container;
        if (null == targetcontainer) {
            targetcontainer = (CliManagedContainer)TargetContainerJavaHelper.defaultTargetContainer((StepPostConstructContext)ctx, CliManagedContainer.class);
        }
        return targetcontainer;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try (OverthereConnection remoteConnection = this.cliStep.getRemoteConnection();){
            CliVarsConverter converter = new CliVarsConverter(ctx, remoteConnection, this.pythonContext, this.uploadArtifactsInPythonContext);
            converter.convert();
            StepExitCode stepExitCode = this.cliStep.execute(ctx);
            return stepExitCode;
        }
    }

    public void requestStaging(StagingContext ctx) {
        if (!this.uploadArtifactsInPythonContext.booleanValue()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.pythonContext.entrySet()) {
            Object entryVal = entry.getValue();
            if (!(entryVal instanceof Artifact)) continue;
            Artifact artifact = (Artifact)entryVal;
            StagedFile stagedFile = ctx.stageArtifact(artifact, (StagingTarget)this.container.getHost());
            this.pythonContext.put(entry.getKey() + "_stagedFile", stagedFile);
        }
    }

    private static class CliVarsConverter {
        private Map<String, Object> pythonContext;
        private ExecutionContext ctx;
        private OverthereConnection remoteConnection;
        private boolean uploadArtifactsInPythonContext;

        private CliVarsConverter(ExecutionContext ctx, OverthereConnection remoteConnection, Map<String, Object> pythonContext, boolean uploadArtifactsInPythonContext) {
            this.ctx = ctx;
            this.remoteConnection = remoteConnection;
            this.pythonContext = pythonContext;
            this.uploadArtifactsInPythonContext = uploadArtifactsInPythonContext;
        }

        private void convert() {
            TreeSet<String> sortedKeys = new TreeSet<String>(this.pythonContext.keySet());
            for (String varName : sortedKeys) {
                Object varValue = this.pythonContext.get(varName);
                logger.trace("Converting variable [{}]", (Object)varName);
                this.convertVariable(varName, varValue);
            }
        }

        private void convertVariable(String varName, Object varValue) {
            if (varValue instanceof Artifact) {
                this.convertArtifact(varName, (Artifact)varValue);
            }
        }

        private void convertArtifact(String varName, Artifact artifact) {
            if (!this.uploadArtifactsInPythonContext) {
                logger.debug("Property 'file' of [{}] will NOT be automatically uploaded and adjusted to point to a remote overthere file.", (Object)varName);
                return;
            }
            String stagedFileVarName = varName + "_stagedFile";
            if (this.ctx != null && this.pythonContext.containsKey(stagedFileVarName)) {
                StagedFile stagedFileReference = (StagedFile)this.pythonContext.get(stagedFileVarName);
                OverthereFile stagedOverthereFile = stagedFileReference.get(this.remoteConnection, this.ctx);
                logger.debug("Setting file property of [{}] to an already staged file [{}]", (Object)varName, (Object)stagedOverthereFile.getPath());
                artifact.setFile(stagedOverthereFile);
                return;
            }
            if (artifact.getFile() == null) {
                logger.debug("Setting file property of [{}] to null because artifact has a null file reference.", (Object)varName);
                return;
            }
            logger.debug("Creating temporary file for variable [{}]", (Object)varName);
            OverthereFile uploadedFileArtifact = this.remoteConnection.getTempFile(artifact.getFile().getName());
            logger.debug("Uploading artifact for variable [{}] to [{}]", (Object)varName, (Object)uploadedFileArtifact.getPath());
            artifact.getFile().copyTo(uploadedFileArtifact);
            logger.debug("Uploaded artifact for variable [{}] to [{}]", (Object)varName, (Object)uploadedFileArtifact.getPath());
            artifact.setFile(uploadedFileArtifact);
        }
    }
}

