/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.glassfish.session.CliSession;
import com.xebialabs.deployit.plugin.glassfish.session.Response;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.List;
import java.util.Map;

public class SingleExecutionSession
implements CliSession {
    private OverthereConnection connection;
    private Host host;

    public SingleExecutionSession(Host host) {
        this.host = host;
    }

    @Override
    public Response execute(String command) {
        if (!this.isConnected()) {
            this.connect();
        }
        CmdLine cmdLine = this.setupCmdLine(command);
        CapturingExecutionContext context = new CapturingExecutionContext();
        int rc = this.connection.execute((OverthereExecutionOutputHandler)DefaultExecutionOutputHandler.handleStdout((ExecutionContext)context), (OverthereExecutionOutputHandler)DefaultExecutionOutputHandler.handleStderr((ExecutionContext)context), cmdLine);
        if (rc != 0) {
            return new Response(rc, context.getAllOutput(), "RC=" + rc + ".");
        }
        return new Response(0, context.getAllOutput());
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void connect() {
        this.disconnect();
        this.connection = this.host.getConnection();
    }

    private CmdLine setupCmdLine(String command) {
        OverthereFile driverFile = this.uploadDriver(command);
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(driverFile.getPath());
        return cmdLine;
    }

    private OverthereFile uploadDriver(String command) {
        OverthereFile driverDir = this.connection.getTempFile("glassfish", "tmp");
        driverDir.mkdirs();
        command = "cd " + driverDir.getPath() + "\n" + command;
        OverthereFile driverFile = driverDir.getFile("ascommandwrapper" + this.connection.getHostOperatingSystem().getScriptExtension());
        OverthereUtils.write((byte[])command.getBytes(), (OverthereFile)driverFile);
        driverFile.setExecutable(true);
        return driverFile;
    }

    private static class CapturingExecutionContext
    implements ExecutionContext {
        private List<String> capturedOutput = Lists.newArrayList();
        private List<String> capturedError = Lists.newArrayList();

        private CapturingExecutionContext() {
        }

        public List<String> getAllOutput() {
            return Lists.newArrayList((Iterable)Iterables.concat(this.capturedOutput, this.capturedError));
        }

        public void logOutput(String output) {
            this.capturedOutput.add(output);
        }

        public void logError(String error) {
            this.capturedError.add(error);
        }

        public void logError(String error, Throwable t) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public Repository getRepository() {
            throw new UnsupportedOperationException();
        }

        public InspectionContext getInspectionContext() {
            throw new UnsupportedOperationException();
        }

        public ITask getTask() {
            return new ITask(){

                public String getUsername() {
                    return "itest";
                }

                public Map<String, String> getMetadata() {
                    return Maps.newHashMap();
                }

                public String getId() {
                    return "itestCapturingExecutionContext";
                }
            };
        }
    }
}

