/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.container;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagingContainer;
import com.xebialabs.deployit.plugin.glassfish.session.CliDaemon;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import java.util.List;

@Metadata(description="GlassFish Cli Managed Container")
public abstract class CliBasedContainer
extends BaseContainer
implements CliManagedContainer,
CliManagingContainer {
    @Property(asContainment=true)
    @InspectionProperty
    private Host host;
    @Property(description="GlassFish home directory (use first-level path containing bin/asadmin)")
    @InspectionProperty
    private String home;
    @Property(required=false, defaultValue="4848", label="Administrative port", description="TCP port which is used to login to DAS, default is 4848")
    @InspectionProperty(required=false)
    private int port;
    @Property(required=false, defaultValue="localhost", label="Administrative Host", description="Host which is used to login to DAS, default is localhost")
    @InspectionProperty(required=false)
    private String adminHostAddress;
    @Property(required=true, label="Administrative username", description="Username which is used to login to DAS.")
    @InspectionProperty(required=false)
    private String username;
    @Property(required=false, password=true, label="Administrative password", defaultValue="", description="Password which is used to login to DAS.")
    @InspectionProperty(required=false)
    private String password;
    @Property(required=false, defaultValue="false", description="Connection to DAS should be secure.")
    @InspectionProperty(required=false)
    private boolean secure;
    @Property(hidden=true, required=false, defaultValue="glassfish/library/runtime.py,glassfish/library/commandHelper.py", description="List of python library scripts that should be automatically loaded when using a GlassFish CLI script.")
    private List<String> libraryScripts = Lists.newArrayList();

    public Host getHost() {
        return this.host;
    }

    @Override
    public String getCliExecutable() {
        OperatingSystemFamily os = this.host.getOs();
        String path = this.getHome() + os.getFileSeparator() + "bin" + os.getFileSeparator() + "asadmin";
        if (os == OperatingSystemFamily.WINDOWS) {
            path = path + os.getScriptExtension();
        }
        return path;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getAdminHostAddress() {
        return this.adminHostAddress;
    }

    public void setAdminHostAddress(String adminHostAddress) {
        this.adminHostAddress = adminHostAddress;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    @Override
    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public void setLibraryScripts(List<String> libraryScripts) {
        this.libraryScripts = libraryScripts;
    }

    @Override
    public CliManagingContainer getManagingContainer() {
        return this;
    }

    @Override
    public Object execute(ExecutionContext ctx, String cmd, boolean withoutDaemon) {
        String attrName = "managingContainersDaemon_" + this.getName();
        CliDaemon daemon = (CliDaemon)ctx.getAttribute(attrName);
        if (daemon == null) {
            daemon = new CliDaemon(this, this.getHost());
            ctx.setAttribute(attrName, (Object)daemon);
        }
        try {
            return daemon.executeCliCommandWithoutDaemon(ctx, cmd);
        }
        catch (RuntimeIOException e) {
            daemon.disconnect();
            ctx.setAttribute(attrName, null);
            throw e;
        }
    }
}

