exposedGeneralPropArgs = exposedPropertiesMap(deployed, "General")
exposedAdditionalPropArgs = exposedPropertiesMap(deployed, "Additional Properties")

def convertBooleanToLowerCase(value):
    if value == "True" or value == "False":
        return value.lower()
    return value

for key,value in Get('resources.jdbc-connection-pool', deployed.name, False).fetch(executeCmd).items():
    resType = value
    if key in exposedGeneralPropArgs.keys():
        if deployed.getProperty(key) != None or deployed.getProperty(key) != "":
            resType = convertBooleanToLowerCase(deployed.getProperty(key))
    if key in optionArgMap.keys():
        if (deployed.getProperty(optionArgMap[key])) != None or (deployed.getProperty(optionArgMap[key])) != "":
            resType = convertBooleanToLowerCase(deployed.getProperty(optionArgMap[key]))
        if key == "res-type":
            if (deployed.getProperty(optionArgMap[key])) != None or (deployed.getProperty(optionArgMap[key])) != "":
                resType = str(deployed.getProperty(optionArgMap[key])).replace('_', '.')
    if key != "name":
        logOutput("Modifying jdbc connection pool %s with args %s=%s" % (deployed.name, key, resType))    
        executeCmd("set resources.jdbc-connection-pool.%s.%s=%s" % (deployed.name, key, resType))

for key, value in exposedAdditionalPropArgs.items():
    key = convertDeployedToGlassfishPropertyName(key, optionArgMap)
    if deployed.getProperty(key) != None or deployed.getProperty(key) != "":
        resType = deployed.getProperty(key)
    else:
        resType = '""'
    logOutput("Modifying jdbc connection pool")
    executeCmd("set resources.jdbc-connection-pool.%s.property.%s=%s" % (deployed.name, key, resType))
logOutput("Done.")