package com.xebialabs.deployit.plugin.glassfish.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.google.common.collect.Collections2.filter;
import static com.google.common.collect.Collections2.transform;
import static com.google.common.collect.Sets.newHashSet;
import static com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor;

public class PropertyHelper {

    private static final Set<String> defaultIgnore = newHashSet("id","type","container","deployable");

    public static void setPropertiesIfExists(ConfigurationItem item, String category, Map<String,String> properties) {
        final Descriptor descriptor = getDescriptor(item.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (pd.getCategory().equals(category) && properties.containsKey(pd.getName())) {
                pd.set(item,properties.get(pd.getName()));
            }
        }
    }

    public static void setPropertiesIfExists(ConfigurationItem item, Map<String,String> properties) {
        final Descriptor descriptor = getDescriptor(item.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (properties.containsKey(pd.getName())) {
                pd.set(item,properties.get(pd.getName()));
            }
        }
    }

    public static Collection<String> getNonHiddenProperties(ConfigurationItem item, String category, Set<String> ignore) {
        final String categoryToSearch = Strings.emptyToNull(category);
        final Set<String> ignoreAll = newHashSet(defaultIgnore);
        ignoreAll.addAll(ignore);
        final Descriptor descriptor = getDescriptor(item.getType());
        Collection<PropertyDescriptor> filter = filter(descriptor.getPropertyDescriptors(), new Predicate<PropertyDescriptor>() {
            public boolean apply(PropertyDescriptor pd) {
                if (pd.isHidden() || ignoreAll.contains(pd.getName())) {
                    return false;
                }

                return categoryToSearch != null && pd.getCategory().equals(categoryToSearch);
            }
        });
        return transform(filter, new Function<PropertyDescriptor, String>() {
            @Override
            public String apply(final PropertyDescriptor input) {
                return input.getName();
            }
        });
    }
}
