package com.xebialabs.deployit.plugin.glassfish.step;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.overthere.OverthereFile;

public class CliStageableStep extends BaseStep implements StageableStep {
    
    private final Artifact artifact;
    private StagedFile stagedFile;

    public CliStageableStep(final Artifact artifact, final String script, final int order, final Map<String, Object> pythonContext,
                            final String description, final CliManagedContainer container) {
        super(script, order, pythonContext, description, container);
        this.artifact = artifact;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }


    @Override
    public void requestStaging(final StagingContext ctx) {
        if(artifact != null){
            stagedFile = ctx.stageArtifact(artifact, getContainer().getHost());
        }
    }
    
    @Override
    public OverthereFile uploadToWorkingDirectory(final OverthereFile content, final String fileName) {
        OverthereFile fileToCopy = content;
        if(stagedFile != null){
            fileToCopy = stagedFile.get(getRemoteConnection(), getCtx());
        }
        return super.uploadToWorkingDirectory(fileToCopy, fileName);
    }
}
