package com.xebialabs.deployit.plugin.glassfish.controltask;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.deployed.CliManagedDeployed;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;
import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.glassfish.step.StepFactory.deploymentStepFactory;

public class ControlTaskDispatcher {

    @Delegate(name = "asadmin")
    public static List<Step> asadminCommandDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        String script = args.get("script");
        checkArgument(!isNullOrEmpty(script), "Argument 'script' is required.");

        Map<String, Object> thisVarContext = newHashMap();
        thisVarContext.put("thisCi", item);

        CliManagedContainer container;
        if (item instanceof CliManagedContainer) {
            container = (CliManagedContainer) item;
            thisVarContext.put("container", container);
        } else if (item instanceof CliManagedDeployed) {
            container = (CliManagedContainer) ((CliManagedDeployed<?, ?>) item).getContainer();
            thisVarContext.put("container", container);
            thisVarContext.put("deployed", item);
        } else {
            throw new IllegalArgumentException(String.format("Control task '%s' can only be run against a CliManagedContainer or CliManagedDeployed. Configuration item '%s' is neither.", name, item));
        }

        if (params != null) {
            thisVarContext.put("params", params);
        }

        return Collections.<Step>singletonList(deploymentStepFactory().createStep(script, 1, thisVarContext, "Executing " + name, container));
    }
}
