import sys
import re
import traceback
from java.util import Map, HashSet, ArrayList
from com.xebialabs.deployit.plugin.glassfish.exception import CliScriptException, CliScriptExit
from com.xebialabs.deployit.plugin.glassfish.session import Response
from com.xebialabs.deployit.plugin.glassfish.util import PropertyHelper

def logErrorAndExit(msg):
    logError(msg)
    logError(joinList("\n",traceback.extract_stack()))
    raise CliScriptExit(msg)

def logOutputAndExit(msg):
    logOutput(msg)
    raise CliScriptExit(msg)

def logError(msg):
    step.ctx.logError(str(msg))

def logOutput(msg):
    step.ctx.logOutput(str(msg))

def executeCmd(cmd, exitOnFailure=True, runWithDaemon=True):
    logOutput("Executing command: " + cmd)
    try:
        if runWithDaemon:
            r = step.executeCliCommand(cmd)
        else:
            r = step.executeCliCommandWithoutDaemon(cmd)
    except:
        logErrorAndExit("Failed to execute command. Error %s with message %s " % (sys.exc_info()[0], sys.exc_info()[1]))

    if exitOnFailure and r and r.exitCode > 0:
        logErrorAndExit(str(r.message) + joinList("\n",r.output))

    return r.output if hasattr(r, 'output') else r

def discovered(container, name, type):
    return step.discovered("%s/%s" % (container.id,name), type)

def inspected(id):
    return step.inspected(id)

def joinList(delimiter, list):
    return delimiter.join(str(x) for x in list)

def exposedPropertiesMap(deployed, category="Options", ignoreNones=True, ignoredProps=HashSet(), d2g={}):
    propArgs = {}
    for prop in PropertyHelper.getNonHiddenProperties(deployed, category, ignoredProps):
        prop = '%s' % prop
        if (ignoreNones == False or deployed.getProperty(prop) != None):
            propArgs[d2g.get(prop, prop)] = preparePropertyValue(deployed, prop)
    return propArgs

def convertDeployedToGlassfishPropertyName(p, g2d):
    if (p not in g2d.values()):
        return p

    d2g = dict((v,k) for k, v in g2d.iteritems())

    return d2g[p]

def getAllContainers(): return List('list-clusters').fetch(executeCmd) + List('list-instances --standaloneonly=true').fetch(executeCmd) + ['server']

def getAllRefs(name, type = 'application'):
    if type not in ['application', 'resource']:
        raise "type should be either resource or application"

    return filter(lambda c: name in getRefs(c, type) , getAllContainers())

def getRefs(container, type = 'application'): return List("list-%s-refs %s" % (type, container)).fetch(executeCmd)


def createRef(name, container, type):
    logOutput("Creating %s reference" % type)
    executeCmd("create-%s-ref --target %s %s" %(type, container, name))
    logOutput("Done")


def deleteRef(name, container, type):
    logOutput("Deleting %s reference" % type)
    executeCmd(Destroy('delete-%s-ref' % type, container, name).build())
    logOutput("Done")

def preparePropertyValue(deployed, p):
    value = '""'
    p = "%s" % p

    if deployed.getProperty(p) != None and deployed.getProperty(p) != "":
        value = deployed.getProperty(p)

    return value

def getVersion():
    return re.search(re.escape("Open Source Edition") + "(.*)" + re.escape("(build"), str(executeCmd("version"))).group(1).strip()
