package com.xebialabs.deployit.plugin.glassfish.step;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;

public class CliInspectionStep extends BaseStep {

    public CliInspectionStep(String script, int order, Map<String, Object> pythonContext, String description, CliManagedContainer container) {
        super(script, order, pythonContext, description, container);
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return handleExecute(ctx);
    }

    public ConfigurationItem discovered(String name, String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
        ConfigurationItem item = descriptor.newInstance(name);
        getCtx().getInspectionContext().discovered(item);
        return item;
    }

    public ConfigurationItem inspected(String name) {
        ConfigurationItem item = getCtx().getInspectionContext().getDiscovered().get(name);
        if (item != null) {
            getCtx().getInspectionContext().inspected(item);
        }
        return item;
    }




}
