package com.xebialabs.deployit.plugin.glassfish.session;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Iterables;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStderr;
import static com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler.handleStdout;

public class SingleExecutionSession implements CliSession {

    private OverthereConnection connection;
    private Host host;

    public SingleExecutionSession(Host host) {
        this.host = host;
    }

    @Override
    public Response execute(String command) {
        if (!isConnected()) {
            connect();
        }

        CmdLine cmdLine = setupCmdLine(command);

        CapturingExecutionContext context = new CapturingExecutionContext();

        int rc = connection.execute(handleStdout(context), handleStderr(context), cmdLine);
        if (rc != 0) {
            return new Response(rc, context.getAllOutput(), "RC=" + rc + ".");
        }

        return new Response(0,context.getAllOutput());
    }

    @Override
    public boolean isConnected() {
        return connection != null;
    }


    @Override
    public void disconnect() {
        if (connection != null) {
            connection.close();
            connection = null;
        }
    }

    @Override
    public void connect() {
        disconnect();
        connection = host.getConnection();
    }

    private CmdLine setupCmdLine(String command) {
        OverthereFile driverFile = uploadDriver(command);
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(driverFile.getPath());
        return cmdLine;
    }

    private OverthereFile uploadDriver(String command) {
        OverthereFile driverDir = connection.getTempFile("glassfish","tmp");
        driverDir.mkdirs();
        command = "cd " + driverDir.getPath() + "\n" + command;
        OverthereFile driverFile = driverDir.getFile("ascommandwrapper" + connection.getHostOperatingSystem().getScriptExtension());
        OverthereUtils.write(command.getBytes(), driverFile);
        driverFile.setExecutable(true);

        return driverFile;
    }

    private static class CapturingExecutionContext implements ExecutionContext {

        private List<String> capturedOutput = newArrayList();
        private List<String> capturedError = newArrayList();

        public List<String> getAllOutput() {
            return newArrayList(Iterables.concat(capturedOutput,capturedError));
        }

        @Override
        public void logOutput(final String output) {
            capturedOutput.add(output);
        }

        @Override
        public void logError(final String error) {
            capturedError.add(error);
        }

        @Override
        public void logError(final String error, final Throwable t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getAttribute(final String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(final String name, final Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Repository getRepository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InspectionContext getInspectionContext() {
            throw new UnsupportedOperationException();
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(SingleExecutionSession.class);

}
