package com.xebialabs.deployit.plugin.glassfish.deployed;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.overthere.OverthereFile;

import static com.google.common.collect.Maps.newHashMap;

@Metadata(virtual = true, description = "Base for all deployed artifacts that utilize the Glassfish Cli for configuration")
@Placeholders
public class CliManagedDeployedArtifact<D extends DeployableArtifact, C extends CliManagedContainer> extends CliManagedDeployed<D, C> implements DerivedArtifact<D> {

    private OverthereFile placeholderProcessedFile;

    @Property(description = "A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required = false)
    private Map<String, String> placeholders = newHashMap();

    @Override
    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    @Override
    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    @Override
    public OverthereFile getFile() {
        return placeholderProcessedFile;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    @Override
    public D getSourceArtifact() {
        return getDeployable();
    }

}
