package com.xebialabs.deployit.plugin.glassfish.contributor;

import java.util.Set;
import com.google.common.collect.ImmutableMap;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.step.CliDeploymentStep;
import com.xebialabs.deployit.plugin.glassfish.constants.ContainerRestartStrategy;

import static com.google.common.collect.Sets.newHashSet;
import static java.lang.String.format;

public class StopStartContainer {

    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String RESTART_ORDER_PROPERTY = "restartOrder";
    public static final String CONTAINER_RESTART_STRATEGY = "containerRestartStrategy";


    @Contributor
    public void stopAndStartContainers(Deltas deltas, DeploymentPlanningContext ctx) {
        Set<CliManagedContainer> stopStartContainers = newHashSet();
        Set<CliManagedContainer> restartStartContainers = newHashSet();

        findContainers(deltas, stopStartContainers, restartStartContainers);
        for (CliManagedContainer wasContainer : stopStartContainers) {
            addStep(STOP_SCRIPT_PROPERTY, STOP_ORDER_PROPERTY, "Stop",wasContainer,ctx);
            addStep(START_SCRIPT_PROPERTY, START_ORDER_PROPERTY, "Start",wasContainer,ctx);
        }

        for (CliManagedContainer wasContainer : restartStartContainers) {
            addStep(STOP_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Stop",wasContainer,ctx);
            addStep(START_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Start",wasContainer,ctx);
        }
    }

    private void addStep(String scriptProperty, String orderProperty, String verb, CliManagedContainer container, DeploymentPlanningContext ctx) {
        if (container.hasProperty(scriptProperty) && container.hasProperty(orderProperty)) {
            ctx.addStep(new CliDeploymentStep(
                    container.<String>getProperty(scriptProperty),
                    container.<Integer>getProperty(orderProperty),
                    ImmutableMap.<String, Object>of("thisCi", container),
                    format("%s '%s'", verb,container.getName()),
                    container
                    ));
        }
    }

    private void findContainers(Deltas deltas, Set<CliManagedContainer> stopStartContainers, Set<CliManagedContainer> restartStartContainers) {
        for (Delta delta : deltas.getDeltas()) {
            Deployed<?,?> deployed = delta.getOperation() == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
            if (deployed.getContainer() instanceof CliManagedContainer) {
                if (deployed.hasProperty(CONTAINER_RESTART_STRATEGY)) {
                    if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) == ContainerRestartStrategy.STOP_START) {
                        stopStartContainers.add((CliManagedContainer)deployed.getContainer());
                    } else if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) == ContainerRestartStrategy.RESTART) {
                        restartStartContainers.add((CliManagedContainer)deployed.getContainer());
                    }
                }
            }
        }

        restartStartContainers.removeAll(stopStartContainers);  //stop_start takes precedence over restart
    }
}
