package com.xebialabs.deployit.plugin.glassfish.container;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.glassfish.controltask.ControlTaskDispatcher;
import com.xebialabs.deployit.plugin.overthere.Host;


@Metadata(description = "Glassfish StandaloneServer")
public class StandaloneServer extends BaseContainer implements RefContainer, CliManagedContainer {

    @Property(asContainment = true, description = "Domain to which the server group belongs.")
    private Domain domain;

    @Property(required = false, description = "Host on which server resides. When emtpy, the host on which the domain resides is used.")
    private Host host;

    @Override
    public CliManagingContainer getManagingContainer() {
        return domain;
    }

    @Override
    public Host getHost() {
        if (host != null) {
            return host;
        }
        return domain.getHost();
    }

    @Override
    public String getTargetName() {
        return getName();
    }
}
