package com.xebialabs.deployit.plugin.glassfish.container;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.glassfish.step.CliInspectionStep;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

@Metadata(inspectable = true)
public class Domain extends CliBasedContainer {

    @Property(required = false, asContainment = true, description = "StandaloneServer groups defined in domain")
    private Set<Cluster> clusters = newHashSet();

    @Property(required = false, asContainment = true, description = "Profiles defined in domain")
    private Set<StandaloneServer> servers = newHashSet();

    @Property(hidden = true, defaultValue = "glassfish/container/inspect-domain.py", description = "Classpath to the script used to inspect the domain.")
    private String inspectScript = "glassfish/container/inspect-domain.py";

    @Inspect
    public void inspect(InspectionContext ctx) {
        Map<String, Object> pyCtx = newHashMap();
        pyCtx.put("container", this);
        CliInspectionStep step = new CliInspectionStep(inspectScript, 0, pyCtx, "Inspect Domain", this);
        ctx.addStep(step);
    }

    public String getTargetName() {
        return "domain";
    }

    public Set<Cluster> getClusters() {
        return clusters;
    }

    public void setClusters(final Set<Cluster> clusters) {
        this.clusters = clusters;
    }

    public Set<StandaloneServer> getServers() {
        return servers;
    }

    public void setServers(final Set<StandaloneServer> servers) {
        this.servers = servers;
    }

}
