package com.xebialabs.deployit.plugin.glassfish.container;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;

import static com.google.common.collect.Sets.newHashSet;


@Metadata(description = "Glassfish Cluster")
public class Cluster extends BaseContainer implements RefContainer, CliManagedContainer {

    @Property(asContainment = true, description = "Domain to which the server group belongs.")
    private Domain domain;

    @Override
    public CliManagingContainer getManagingContainer() {
        return domain;
    }

    @Override
    public Host getHost() {
        return domain.getHost();
    }

    @Override
    public String getTargetName() {
        return getName();
    }

}

