def parseOutputList(rawOutput, lineLambda):
    parsedOutput = []
    for rawLine in rawOutput:
        if rawLine == "Nothing to list.":
            break
        if rawLine.startswith("Command") and rawLine.endswith("executed successfully."):
            continue

        parsedOutput.append(lineLambda(rawLine))
    return parsedOutput

class Create:

    def __init__(self, command, options={}, properties={}, finalArgument=''):
        self.command = command
        self.options = options
        self.properties = properties
        self.finalArgument = finalArgument

    def build(self):

        def val(v):
            if (isinstance(v, bool)):
                return str(v).lower()

            return  '"%s"' % str(v).replace('"','\\"')

        optionsString = reduce(lambda a, (k, v): "%s --%s %s" % (a, k, val(v)) , self.options.items(), "")

        propertiesString = reduce(
            lambda a, (k, v): "%s:%s=%s" % (a, k, val(v)) if a else " --property %s=%s" % (k, val(v)),
            self.properties.items(),
            ""
        )

        return self.command + optionsString + propertiesString + (" " + self.finalArgument if self.finalArgument else '')

class Destroy:
    def __init__(self, command, target, object):
        self.command = command
        self.target = target
        self.object = object

    def build(self):
        return '%s --target "%s" %s' % (self.command, self.target, self.object)

class Get:

    def __init__(self, prefix, name = None, propsMode = None):
        self.command = 'get'
        self.query = "%s.%s." % (prefix, name) if name else "%s." % prefix

        stripQuery = lambda t: (t[0][len(self.query):], t[1]) if t[0].startswith(self.query) else t
        stripProperty = lambda t: (t[0][9:], t[1]) if t[0].startswith('property.') else t

        if propsMode == None:
            self.filter = lambda p: True
            self.stripper = lambda t: stripProperty(stripQuery(t))
        elif propsMode == False:
            self.filter = lambda t: not t[0].startswith(self.query + 'property')
            self.stripper = stripQuery
        elif propsMode == True:
            self.filter = lambda t: t[0].startswith(self.query + 'property')
            self.stripper = lambda t: stripProperty(stripQuery(t))


    def build(self):
        return "%s %s*" % (self.command, self.query)

    def fetch(self, run):
        if (not hasattr(run, '__call__')):
            raise "executor should be a function"

        def value(v):
            if v == 'true': return True
            if v == 'false': return False
            return v


        def treatLine(l):
            vv = l.strip().split('=')
            return (vv[0], value(vv[1]))

        return dict(map(self.stripper, filter(self.filter, parseOutputList(run(self.build()), treatLine))))

class List:

    def __init__(self, command):
        self.command = command

    def fetch(self, run):
        if (not hasattr(run, '__call__')):
            raise "executor should be a function"

        return parseOutputList(run(self.command), lambda l: l.strip().partition(' ')[0])

