/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.session;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.glassfish.container.CliBasedContainer;
import com.xebialabs.deployit.plugin.glassfish.session.CliSession;
import com.xebialabs.deployit.plugin.glassfish.session.Response;
import com.xebialabs.deployit.plugin.glassfish.session.SingleExecutionSession;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliDaemon
implements ExecutionContextListener,
Serializable {
    private final Host connectingHost;
    private CliBasedContainer container;
    private String asadminCmdline;
    private String asadminFileName;
    private transient CliSession singleExecutionSession;
    private static final FileUploader NULL_FILE_UPLOADER = new FileUploader(){
        private final String EMPTY = "";

        public String upload(OverthereFile file) {
            return "";
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(CliDaemon.class);

    public CliDaemon(CliBasedContainer container, Host connectingHost) {
        this.container = container;
        this.connectingHost = connectingHost;
        this.asadminFileName = connectingHost.getOs() == OperatingSystemFamily.WINDOWS ? "asadmin.bat" : "asadmin";
        this.loadAsadminCmdLine();
    }

    private void loadAsadminCmdLine() {
        try {
            HashMap vars = Maps.newHashMap();
            vars.put("container", this.container);
            Template template = ConfigurationHolder.getConfiguration().getTemplate("glassfish/cli/asadmin-cmdline-driver.ftl");
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment((Object)vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper(NULL_FILE_UPLOADER, false)).process();
            sw.write(32);
            this.asadminCmdline = sw.toString();
            if (logger.isTraceEnabled()) {
                StringWriter debug = new StringWriter();
                template.createProcessingEnvironment((Object)vars, (Writer)debug, (ObjectWrapper)new CiAwareObjectWrapper(NULL_FILE_UPLOADER, true)).process();
                debug.write(32);
                logger.trace("ascommand drive content:\n" + debug.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public Response executeCliCommandWithoutDaemon(ExecutionContext context, String cmd) {
        return this.getSession().execute(this.asadminCmdline + " " + cmd);
    }

    public Response executeCliCommand(ExecutionContext context, String cmd) {
        return this.executeCliCommandWithoutDaemon(context, cmd);
    }

    public void disconnect() {
        if (this.singleExecutionSession != null) {
            this.singleExecutionSession.disconnect();
        }
    }

    public void connect() {
        this.getSession().connect();
    }

    public void contextDestroyed() {
        this.disconnect();
    }

    private CliSession getSession() {
        if (this.singleExecutionSession == null) {
            this.singleExecutionSession = new SingleExecutionSession(this.connectingHost);
        }
        return this.singleExecutionSession;
    }
}

