/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.step.BaseStep;
import com.xebialabs.deployit.plugin.glassfish.step.CliDeploymentStep;
import com.xebialabs.deployit.plugin.glassfish.step.CliStageableStep;
import java.util.List;
import java.util.Map;

public abstract class StepFactory {
    protected List<String> libraries;

    private StepFactory() {
    }

    public StepFactory withLibraries(List<String> libraries) {
        this.libraries = Lists.newArrayList(libraries);
        return this;
    }

    public BaseStep createStep(String script, int order, Map<String, Object> pyCtx, String description, CliManagedContainer container) {
        BaseStep step = this.newStep(script, order, pyCtx, description, container);
        if (this.libraries != null) {
            step.setAdditionalLibraries(this.libraries);
        }
        return step;
    }

    protected abstract BaseStep newStep(String var1, int var2, Map<String, Object> var3, String var4, CliManagedContainer var5);

    public static StepFactory stagingStepFactory(Artifact artifact) {
        return new StagingStepFactory(artifact);
    }

    public static StepFactory deploymentStepFactory() {
        return new DeploymentStepFactory();
    }

    private static class DeploymentStepFactory
    extends StepFactory {
        private DeploymentStepFactory() {
        }

        @Override
        protected BaseStep newStep(String script, int order, Map<String, Object> pyCtx, String description, CliManagedContainer container) {
            return new CliDeploymentStep(script, order, pyCtx, description, container);
        }
    }

    private static class StagingStepFactory
    extends StepFactory {
        private final Artifact artifact;

        private StagingStepFactory(Artifact artifact) {
            Preconditions.checkNotNull((Object)(artifact != null ? 1 : 0), (Object)"Artifact must be specified");
            this.artifact = artifact;
        }

        @Override
        protected BaseStep newStep(String script, int order, Map<String, Object> pyCtx, String description, CliManagedContainer container) {
            return new CliStageableStep(this.artifact, script, order, pyCtx, description, container);
        }
    }
}

