logOutput("Inspecting clusters")

for cluster in List("list-clusters").fetch(executeCmd):
    ci = discovered(container, cluster, "glassfish.Cluster")
    container.clusters.add(ci)
    inspected(ci.id)

logOutput("Inspecting instances")
standaloneServers = List("list-instances --nostatus --standaloneonly=true").fetch(executeCmd)
standaloneServers.append("server")
for serverName in standaloneServers:
    ci = discovered(container, serverName, "glassfish.StandaloneServer")
    container.servers.add(ci)
    inspected(ci.id)
logOutput("Done.")
