/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.glassfish.constants.ContainerRestartStrategy;
import com.xebialabs.deployit.plugin.glassfish.container.CliManagedContainer;
import com.xebialabs.deployit.plugin.glassfish.step.StepFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StopStartContainer {
    private static final String APPLY_CONTAINER_RESTART_STRATEGY_ON_NOOP_PROPERTY = "applyContainerRestartStrategyOnNoop";
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String RESTART_ORDER_PROPERTY = "restartOrder";
    public static final String CONTAINER_RESTART_STRATEGY = "containerRestartStrategy";

    @Contributor
    public static void stopAndStartContainers(Deltas deltas, DeploymentPlanningContext ctx) {
        HashSet stopStartContainers = Sets.newHashSet();
        HashSet restartStartContainers = Sets.newHashSet();
        StopStartContainer.findContainers(deltas, stopStartContainers, restartStartContainers);
        for (CliManagedContainer wasContainer : stopStartContainers) {
            StopStartContainer.addStep(STOP_SCRIPT_PROPERTY, STOP_ORDER_PROPERTY, "Stop", wasContainer, ctx);
            StopStartContainer.addStep(START_SCRIPT_PROPERTY, START_ORDER_PROPERTY, "Start", wasContainer, ctx);
        }
        for (CliManagedContainer wasContainer : restartStartContainers) {
            StopStartContainer.addStep(STOP_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Stop", wasContainer, ctx);
            StopStartContainer.addStep(START_SCRIPT_PROPERTY, RESTART_ORDER_PROPERTY, "Start", wasContainer, ctx);
        }
    }

    private static void addStep(String scriptProperty, String orderProperty, String verb, CliManagedContainer container, DeploymentPlanningContext ctx) {
        if (container.hasProperty(scriptProperty) && container.hasProperty(orderProperty)) {
            ctx.addStep((Step)StepFactory.deploymentStepFactory().createStep((String)container.getProperty(scriptProperty), (Integer)container.getProperty(orderProperty), (Map<String, Object>)ImmutableMap.of((Object)"thisCi", (Object)container), String.format("%s '%s'", verb, container.getName()), container));
        }
    }

    private static void findContainers(Deltas deltas, Set<CliManagedContainer> stopStartContainers, Set<CliManagedContainer> restartStartContainers) {
        for (Delta delta : deltas.getDeltas()) {
            Operation operation = delta.getOperation();
            Deployed deployed = operation == Operation.DESTROY ? delta.getPrevious() : delta.getDeployed();
            Container container = deployed.getContainer();
            if (!(container instanceof CliManagedContainer)) continue;
            CliManagedContainer cliContainer = (CliManagedContainer)container;
            if (!deployed.hasProperty(CONTAINER_RESTART_STRATEGY) || !StopStartContainer.shouldApplyRestartStrategy(operation, deployed)) continue;
            if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) == ContainerRestartStrategy.STOP_START) {
                stopStartContainers.add(cliContainer);
                continue;
            }
            if (deployed.getProperty(CONTAINER_RESTART_STRATEGY) != ContainerRestartStrategy.RESTART) continue;
            restartStartContainers.add(cliContainer);
        }
        restartStartContainers.removeAll(stopStartContainers);
    }

    private static boolean shouldApplyRestartStrategy(Operation operation, Deployed<?, ?> deployed) {
        boolean applyRestartStrategyOnNoop = false;
        if (deployed.hasProperty(APPLY_CONTAINER_RESTART_STRATEGY_ON_NOOP_PROPERTY)) {
            applyRestartStrategyOnNoop = (Boolean)deployed.getProperty(APPLY_CONTAINER_RESTART_STRATEGY_ON_NOOP_PROPERTY);
        }
        return operation != Operation.NOOP || applyRestartStrategyOnNoop;
    }
}

