/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.glassfish.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertyHelper {
    private static final Set<String> defaultIgnore = Sets.newHashSet((Object[])new String[]{"id", "type", "container", "deployable"});

    public static void setPropertiesIfExists(ConfigurationItem item, String category, Map<String, String> properties) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!pd.getCategory().equals(category) || !properties.containsKey(pd.getName())) continue;
            pd.set(item, (Object)properties.get(pd.getName()));
        }
    }

    public static void setPropertiesIfExists(ConfigurationItem item, Map<String, String> properties) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!properties.containsKey(pd.getName())) continue;
            pd.set(item, (Object)properties.get(pd.getName()));
        }
    }

    public static Collection<String> getNonHiddenProperties(ConfigurationItem item, String category, Set<String> ignore) {
        final String categoryToSearch = Strings.emptyToNull((String)category);
        final HashSet ignoreAll = Sets.newHashSet(defaultIgnore);
        ignoreAll.addAll(ignore);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        Collection filter = Collections2.filter((Collection)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor pd) {
                if (pd.isHidden() || ignoreAll.contains(pd.getName())) {
                    return false;
                }
                return categoryToSearch != null && pd.getCategory().equals(categoryToSearch);
            }
        });
        return Collections2.transform((Collection)filter, (Function)new Function<PropertyDescriptor, String>(){

            public String apply(PropertyDescriptor input) {
                return input.getName();
            }
        });
    }
}

