jndiName = deployed.getProperty("jndiName")
resourceTargetName = deployed.container.targetName

referencedTargets = getAllRefs(jndiName, 'resource')

# Deleting resource references
for c in referencedTargets:
    deleteRef(jndiName, c, 'resource')

# Deleting an old version of resource
logOutput("Deleting jdbc resource")
executeCmd("delete-jdbc-resource --target %s %s" % (resourceTargetName, jndiName))

# Creating a new one
logOutput("Creating jdbc resource")
executeCmd("create-jdbc-resource --connectionpoolid %s --target %s %s" % (deployed.getProperty("poolName"), resourceTargetName, jndiName))
logOutput("Done.")

# Restoring references
for c in referencedTargets:
    createRef(jndiName, c, 'resource')