/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControlTaskDelegate {
    @Delegate(name="localShellScripts")
    public static List<Step> localShellScriptsDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        Host localHost = (Host)Type.valueOf((String)"overthere.LocalHost").getDescriptor().newInstance("Infrastructure/localhost");
        localHost.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        return ControlTaskDelegate.doShellScriptsDelegate(item, (HostContainer)localHost, name, args, params);
    }

    @Delegate(name="shellScripts")
    public static List<Step> executedScriptsDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        HostContainer targetHost = ControlTaskDelegate.determineHost(item, name, args.get("host"), params);
        return ControlTaskDelegate.doShellScriptsDelegate(item, targetHost, name, args, params);
    }

    public static List<Step> doShellScriptsDelegate(ConfigurationItem item, HostContainer targetHost, String name, Map<String, String> args, Parameters params) {
        Map<String, Object> thisVarContext = ControlTaskDelegate.createContext(item, params, targetHost);
        Map<String, String> scriptAliases = ControlTaskDelegate.determineScripts(args);
        String classpathResources = "";
        String templateClasspathResources = "";
        if (!Strings.isNullOrEmpty((String)args.get("classpathResources"))) {
            classpathResources = args.get("classpathResources").trim() + ",";
        }
        if (!Strings.isNullOrEmpty((String)args.get("templateClasspathResources"))) {
            templateClasspathResources = args.get("templateClasspathResources").trim() + ",";
        }
        ArrayList steps = Lists.newArrayList();
        for (Map.Entry<String, String> entry : scriptAliases.entrySet()) {
            String alias = entry.getKey();
            String scriptClasspathResources = classpathResources + Strings.nullToEmpty((String)args.get(alias + "ClasspathResources"));
            String scriptTemplateClasspathResources = templateClasspathResources + Strings.nullToEmpty((String)args.get(alias + "TemplateClasspathResources"));
            Step step = ControlTaskDelegate.createStep(entry.getValue(), targetHost, scriptClasspathResources, scriptTemplateClasspathResources, thisVarContext);
            steps.add(step);
        }
        return steps;
    }

    @Delegate(name="localShellScript")
    public static List<Step> localShellScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        Host localHost = (Host)Type.valueOf((String)"overthere.LocalHost").getDescriptor().newInstance("Infrastructure/localhost");
        localHost.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        return ControlTaskDelegate.doShellScriptDelegate(item, name, args, params, (HostContainer)localHost);
    }

    @Delegate(name="shellScript")
    public static List<Step> executedScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        HostContainer targetHost = ControlTaskDelegate.determineHost(item, name, args.get("host"), params);
        return ControlTaskDelegate.doShellScriptDelegate(item, name, args, params, targetHost);
    }

    private static List<Step> doShellScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params, HostContainer targetHost) {
        Map<String, Object> thisVarContext = ControlTaskDelegate.createContext(item, params, targetHost);
        String script = ControlTaskDelegate.determineScript(item, name, args);
        Step step = ControlTaskDelegate.createStep(script, targetHost, args.get("classpathResources"), args.get("templateClasspathResources"), thisVarContext);
        return Collections.singletonList(step);
    }

    private static Map<String, String> determineScripts(Map<String, String> args) {
        String unparsedScripts = args.get("scripts");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)unparsedScripts) ? 1 : 0) != 0, (Object)"Argument [scripts] is required.");
        Iterable scripts = ConfigurationHolder.RESOLVED_STRING_COLLECTION_SPLITTER.split((CharSequence)unparsedScripts);
        LinkedHashMap scriptAliases = Maps.newLinkedHashMap();
        int count = 1;
        Splitter splitColon = Splitter.on((String)":").omitEmptyStrings().trimResults();
        for (String script : scripts) {
            Iterable aliasScript = splitColon.split((CharSequence)script);
            Iterator iterator = aliasScript.iterator();
            if (Iterables.size((Iterable)aliasScript) == 1) {
                scriptAliases.put("script" + count++, iterator.next());
                continue;
            }
            scriptAliases.put(iterator.next(), iterator.next());
        }
        return scriptAliases;
    }

    private static String determineScript(ConfigurationItem item, String name, Map<String, String> args) {
        String script = args.get("script");
        if (Strings.isNullOrEmpty((String)script)) {
            String scriptPropertyName = name + "Script";
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(scriptPropertyName);
            Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object)scriptPropertyName, (Object)item.getType());
            script = (String)propertyDescriptor.get(item);
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)script) ? 1 : 0) != 0, (Object)"Argument [script] is required.");
        return script;
    }

    private static Step createStep(String script, HostContainer host, String classpathResources, String templateClasspathResources, Map<String, Object> thisVarContext) {
        Iterable resources;
        String scriptName = ConfigurationHolder.resolveExpression(script, thisVarContext);
        String targetFile = ScriptExecutionStep.resolveOsSpecificFileName(scriptName, host);
        String desc = "Executing " + targetFile + " on " + host;
        ScriptExecutionStep step = new ScriptExecutionStep(1, scriptName, host, thisVarContext, desc);
        if (!Strings.isNullOrEmpty((String)classpathResources)) {
            resources = ConfigurationHolder.RESOLVED_STRING_COLLECTION_SPLITTER.split((CharSequence)classpathResources);
            step.setClasspathResources(ConfigurationHolder.resolveExpression(Lists.newArrayList((Iterable)resources), thisVarContext));
        }
        if (!Strings.isNullOrEmpty((String)templateClasspathResources)) {
            resources = ConfigurationHolder.RESOLVED_STRING_COLLECTION_SPLITTER.split((CharSequence)templateClasspathResources);
            step.setTemplateClasspathResources(ConfigurationHolder.resolveExpression(Lists.newArrayList((Iterable)resources), thisVarContext));
        }
        return step;
    }

    private static Map<String, Object> createContext(ConfigurationItem item, Parameters params, HostContainer host) {
        HashMap thisVarContext = Maps.newHashMap();
        thisVarContext.put("thisCi", item);
        thisVarContext.put("targetHost", host);
        if (item instanceof Container) {
            thisVarContext.put("container", item);
        } else if (item instanceof Deployed) {
            thisVarContext.put("deployed", item);
            thisVarContext.put("container", item.getProperty("container"));
        } else {
            thisVarContext.put("container", host);
        }
        if (params != null) {
            thisVarContext.put("params", params);
        }
        return thisVarContext;
    }

    private static HostContainer determineHost(ConfigurationItem item, String name, String hostExpression, Parameters params) {
        if (hostExpression == null) {
            if (item instanceof HostContainer) {
                return (HostContainer)item;
            }
            if (item instanceof Deployed && item.getProperty("container") instanceof HostContainer) {
                return (HostContainer)item.getProperty("container");
            }
            throw new IllegalStateException(String.format("Cannot determine host for method [%s.%s], please use [host] argument to specify target host on which to run script(s).", item.getType(), name));
        }
        Pattern expressionPattern = Pattern.compile("^\\$\\{([\\w.]+)\\}$");
        Matcher matcher = expressionPattern.matcher(hostExpression);
        if (matcher.matches()) {
            ArrayDeque<String> pathStack = new ArrayDeque<String>(Arrays.asList(matcher.group(1).split("[.]")));
            String startingCiName = (String)pathStack.pop();
            ConfigurationItem startingCi = null;
            if (startingCiName.equals("thisCi") || startingCiName.equals("container") || startingCiName.equals("deployed")) {
                startingCi = item;
            } else if (startingCiName.equals("params")) {
                startingCi = params;
            } else {
                startingCi = item;
                pathStack.addFirst(startingCiName);
            }
            try {
                ConfigurationItem potentialHostCi = ControlTaskDelegate.getProperty(startingCi, pathStack);
                if (potentialHostCi instanceof HostContainer) {
                    return (HostContainer)potentialHostCi;
                }
                throw new IllegalArgumentException(String.format("Expression [%s] for argument [%s.%s.host] resolved to a type other than [ . ", hostExpression, item.getType(), name));
            }
            catch (IllegalArgumentException e) {
                String invalidExpressionMsg = String.format("Cannot resolve expression [%s] for argument [%s.%s.host]. %s ", hostExpression, item.getType(), name, e.getMessage());
                throw new IllegalArgumentException(invalidExpressionMsg);
            }
        }
        throw new IllegalArgumentException(String.format("Argument %s.%s.host has an invalid expression format. Expected to be [${..}] but was [%s].", item.getType(), name, hostExpression));
    }

    private static ConfigurationItem getProperty(ConfigurationItem item, Deque<String> pathStack) {
        String propName = pathStack.pop();
        if (item.hasProperty(propName)) {
            Object nextItem = item.getProperty(propName);
            if (nextItem == null) {
                throw new IllegalArgumentException(String.format("Property [%.s.%s] is null.", item.getType(), propName));
            }
            if (nextItem instanceof ConfigurationItem) {
                if (pathStack.isEmpty()) {
                    return (ConfigurationItem)nextItem;
                }
                return ControlTaskDelegate.getProperty((ConfigurationItem)nextItem, pathStack);
            }
            throw new IllegalArgumentException(String.format("Property [%s.%s] kind invalid. Expecting kind [CI] but was [%s].", item.getType(), propName, item.getType().getDescriptor().getPropertyDescriptor(propName).getKind()));
        }
        throw new IllegalArgumentException(String.format("Property [%s] not defined for type [%s].", propName, item.getType()));
    }
}

