package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;

import java.io.File;

public final class ArtifactFileUtils {

    public static File getJavaIoFile(OverthereFile overthereFile) {
        if (overthereFile instanceof LocalFile) {
            return ((LocalFile) overthereFile).getFile();
        } else if (overthereFile instanceof ArtifactFile) {
            ArtifactFile artifactFile = (ArtifactFile) overthereFile;
            if (artifactFile.isResolvable() || artifactFile.isResolved()) {
                return new File(artifactFile.getPath());
            }
        }
        return null;
    }
}
