/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ClasspathTemplateLoader;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHolder {
    private static final AtomicReference<Configuration> holder = new AtomicReference();
    private static final String EXPRESSION_TOKEN = "${";
    private static final String EXPRESSION_IF_TOKEN = "<#if";
    public static final Splitter RESOLVED_STRING_COLLECTION_SPLITTER = Splitter.onPattern((String)"(?<!\\\\),").omitEmptyStrings().trimResults();
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationHolder.class);

    public static Configuration getConfiguration() {
        Configuration conf = holder.get();
        if (conf == null && !holder.compareAndSet(null, conf = ConfigurationHolder.init())) {
            conf = holder.get();
        }
        return conf;
    }

    public static List<String> resolveExpression(List<String> expressions, Object context) {
        return ConfigurationHolder.resolveExpression(expressions, context, false);
    }

    public static List<String> resolveExpression(List<String> expressions, Object context, boolean maskPasswords) {
        return ConfigurationHolder.transformCollectionByResolvingExpression(expressions, context, Lists.newArrayList(), maskPasswords);
    }

    public static Set<String> resolveExpression(Set<String> expressions, Object context) {
        return ConfigurationHolder.resolveExpression(expressions, context, false);
    }

    public static Set<String> resolveExpression(Set<String> expressions, Object context, boolean maskPasswords) {
        return ConfigurationHolder.transformCollectionByResolvingExpression(expressions, context, Sets.newHashSet(), maskPasswords);
    }

    private static <T extends Collection<String>> T transformCollectionByResolvingExpression(T expressions, Object context, T collector, boolean maskPasswords) {
        if (expressions == null) {
            return collector;
        }
        Function<String, String> restoreEscapedComma = new Function<String, String>(){

            public String apply(String input) {
                if (input != null) {
                    return input.replace("\\,", ",");
                }
                return null;
            }
        };
        for (String expression : expressions) {
            String resolvedValueWithPotentialCommaSeparators = ConfigurationHolder.resolveExpression(expression, context, maskPasswords);
            Iterable resolvedValues = RESOLVED_STRING_COLLECTION_SPLITTER.split((CharSequence)resolvedValueWithPotentialCommaSeparators);
            Iterable resolvedValuesWithRestoredCommas = Iterables.transform((Iterable)resolvedValues, (Function)restoreEscapedComma);
            Iterables.addAll(collector, (Iterable)resolvedValuesWithRestoredCommas);
        }
        return collector;
    }

    public static Map<String, String> resolveExpression(Map<String, String> expressions, Map<String, Object> context) {
        return ConfigurationHolder.resolveExpression(expressions, context, false);
    }

    public static Map<String, String> resolveExpression(Map<String, String> expressions, Map<String, Object> context, final boolean maskPasswords) {
        if (expressions == null) {
            expressions = Maps.newHashMap();
        }
        final HashMap contextWithExpressions = Maps.newHashMap(context);
        contextWithExpressions.putAll(expressions);
        return Maps.transformValues((Map)expressions, (Function)new Function<String, String>(){

            public String apply(String input) {
                String result = input;
                while (ConfigurationHolder.isResolvable(result)) {
                    result = ConfigurationHolder.resolveExpression(result, (Object)contextWithExpressions, maskPasswords);
                }
                return result;
            }
        });
    }

    public static String resolveExpression(String expression, Object context) {
        return ConfigurationHolder.resolveExpression(expression, context, false);
    }

    public static String resolveExpression(String expression, Object context, boolean maskPasswords) {
        if (!ConfigurationHolder.isResolvable(expression)) {
            return expression;
        }
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            logger.trace("Resolving expression {}.", (Object)expression);
            Template template = new Template("expression", (Reader)new StringReader(expression), cfg);
            if (maskPasswords) {
                template.setObjectWrapper((ObjectWrapper)new CiAwareObjectWrapper(null, true));
            }
            StringWriter sw = new StringWriter();
            template.process(context, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isResolvable(String expression) {
        return expression != null && (expression.contains(EXPRESSION_TOKEN) || expression.contains(EXPRESSION_IF_TOKEN));
    }

    private static Configuration init() {
        Configuration conf = new Configuration();
        conf.setNumberFormat("computer");
        conf.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        conf.setObjectWrapper((ObjectWrapper)new CiAwareObjectWrapper());
        return conf;
    }
}

