/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.PreviewExecutionContext;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;

public class TemplateArtifactCopyStep
extends ArtifactCopyStep
implements PreviewStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    private Map<String, Object> vars;
    private String templatePath;
    private Preview preview;

    public TemplateArtifactCopyStep(int order, HostContainer container, Map<String, Object> vars, String templatePath, String targetPath) {
        super(order, null, container, targetPath);
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", (Object)this);
        this.templatePath = templatePath;
        Preconditions.checkNotNull((Object)templatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preview getPreview() {
        if (this.preview == null) {
            try {
                HashMap variables = Maps.newHashMap(this.vars);
                variables.put("context", new PreviewExecutionContext());
                String contents = this.evaluateTemplate(this.templatePath, this.vars, true);
                this.preview = Preview.withSourcePathAndContents((String)this.templatePath, (String)contents);
            }
            finally {
                this.disconnect();
            }
        }
        return this.preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StepExitCode doExecute() throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            StepExitCode stepExitCode = super.doExecute();
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile localTemp = this.getLocalConnection().getTempFile("generic_plugin", ".tmp");
        this.evaluateTemplate(localTemp, this.templatePath, this.vars);
        return localTemp;
    }
}

