package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiAwareObjectWrapper extends DefaultObjectWrapper {

    private ArtifactUploader uploader;
    private boolean maskPasswords;

    public CiAwareObjectWrapper() {
    }

    /**
     * @deprecated Use {@link #CiAwareObjectWrapper(ArtifactUploader, boolean)} instead.
     */
    public CiAwareObjectWrapper(ArtifactUploader uploader) {
        this(uploader, false);
    }

    public CiAwareObjectWrapper(ArtifactUploader uploader, boolean maskPasswords) {
        this.uploader = uploader;
        this.maskPasswords = maskPasswords;
    }

    @Override
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj != null && obj instanceof ConfigurationItem) {
            return new CiTemplateModel((ConfigurationItem) obj, this, maskPasswords);
        }
        return super.wrap(obj);
    }

    ArtifactUploader getUploader() {
        return uploader;
    }
}
