/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.container;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.ci.BaseGenericContainer;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LifeCycleContributor {
    @Contributor
    public static void restartContainers(Deltas deltas, DeploymentPlanningContext plan) {
        Set<BaseGenericContainer> containers = LifeCycleContributor.gatherTargets(deltas.getDeltas());
        for (BaseGenericContainer container : containers) {
            if (!LifeCycleContributor.isNullOrEmpty(container.getRestartScript())) {
                LifeCycleContributor.addRestartSteps(plan, container);
                continue;
            }
            LifeCycleContributor.addStartAndStopSteps(plan, container);
        }
    }

    private static void addStartAndStopSteps(DeploymentPlanningContext plan, BaseGenericContainer target) {
        Preconditions.checkArgument((!LifeCycleContributor.isNullOrEmpty(target.getStartScript()) ? 1 : 0) != 0, (Object)String.format("%s start script must be specified when no restart script defined.", target.getId()));
        Preconditions.checkArgument((!LifeCycleContributor.isNullOrEmpty(target.getStopScript()) ? 1 : 0) != 0, (Object)String.format("%s stop script must be specified when no restart script defined.", target.getId()));
        plan.addStep(LifeCycleContributor.createScriptStep("Start", target, target.getStartScript(), target.getStartOrder(), target.getStartClasspathResources(), target.getStartTemplateClasspathResources()));
        LifeCycleContributor.addWaitStep(plan, "start", target, target.getStartWaitTime(), target.getStartOrder());
        plan.addStep(LifeCycleContributor.createScriptStep("Stop", target, target.getStopScript(), target.getStopOrder(), target.getStopClasspathResources(), target.getStopTemplateClasspathResources()));
        LifeCycleContributor.addWaitStep(plan, "stop", target, target.getStopWaitTime(), target.getStopOrder());
    }

    private static void addRestartSteps(DeploymentPlanningContext plan, BaseGenericContainer target) {
        Step step = LifeCycleContributor.createScriptStep("Restart", target, target.getRestartScript(), target.getRestartOrder(), target.getRestartClasspathResources(), target.getRestartTemplateClasspathResources());
        plan.addStep(step);
        LifeCycleContributor.addWaitStep(plan, "restart", target, target.getRestartWaitTime(), target.getRestartOrder());
    }

    private static void addWaitStep(DeploymentPlanningContext plan, String action, BaseGenericContainer target, int waitTime, int scriptOrder) {
        if (waitTime > 0) {
            plan.addStep((Step)new WaitStep(scriptOrder + 1, waitTime, target.getName(), action));
        }
    }

    private static Step createScriptStep(String verb, BaseGenericContainer container, String script, int scriptOrder, Set<String> classpathResources, Set<String> templateClasspathResources) {
        ScriptExecutionStep step;
        HashMap vars = Maps.newHashMap();
        vars.put("container", container);
        Host lifecycleConnectionHost = container.getStopStartRestartConnection();
        if (lifecycleConnectionHost != null) {
            String description = String.format("%s using connection settings for %s", LifeCycleContributor.getDescription(verb, container), lifecycleConnectionHost.getName());
            step = new ScriptExecutionStep(scriptOrder, script, (HostContainer)lifecycleConnectionHost, (Map<String, Object>)vars, description);
        } else {
            step = new ScriptExecutionStep(scriptOrder, script, (HostContainer)container, (Map<String, Object>)vars, LifeCycleContributor.getDescription(verb, container));
        }
        step.setClasspathResources(Lists.newArrayList(classpathResources));
        step.setTemplateClasspathResources(Lists.newArrayList(templateClasspathResources));
        return step;
    }

    private static String getDescription(String verb, BaseGenericContainer container) {
        return String.format("%s %s", verb, container.getName());
    }

    private static Set<BaseGenericContainer> gatherTargets(List<Delta> operations) {
        TreeSet targets = Sets.newTreeSet();
        for (Delta operation : operations) {
            LifeCycleContributor.addTarget(targets, operation.getOperation(), operation.getDeployed());
            LifeCycleContributor.addTarget(targets, operation.getOperation(), operation.getPrevious());
        }
        return targets;
    }

    private static void addTarget(Set<BaseGenericContainer> targets, Operation operation, Deployed<?, ?> deployed) {
        AbstractDeployed abstractDeployed;
        boolean restartRequired;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof AbstractDeployed && (restartRequired = (abstractDeployed = (AbstractDeployed)deployed).isRestartRequired()) && (operation != Operation.NOOP || abstractDeployed.isRestartRequiredForNoop())) {
            targets.add(LifeCycleContributor.getContainerToRestart(deployed.getContainer()));
        }
    }

    private static BaseGenericContainer getContainerToRestart(com.xebialabs.deployit.plugin.api.udm.Container c) {
        if (c instanceof Container) {
            return (Container)c;
        }
        if (c instanceof NestedContainer) {
            NestedContainer nc = (NestedContainer)c;
            if (!(LifeCycleContributor.isNullOrEmpty(nc.getStartScript()) && LifeCycleContributor.isNullOrEmpty(nc.getStopScript()) && LifeCycleContributor.isNullOrEmpty(nc.getRestartScript()))) {
                return nc;
            }
            return LifeCycleContributor.getContainerToRestart(nc.getParentContainer());
        }
        throw new IllegalStateException(String.format("Container [%s] is not a generic (nested) container", c));
    }

    private static boolean isNullOrEmpty(String s) {
        return Strings.nullToEmpty((String)s).trim().isEmpty();
    }
}

