/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;

public class ArtifactCopyStep
extends BaseDeploymentStep
implements StageableStep {
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private Artifact sourceArtifact;
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private boolean preserveExistingFiles;
    private StagedFile stagedSourceArtifact;

    public ArtifactCopyStep(int order, OverthereFile sourceFile, HostContainer container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Preconditions.checkNotNull((Object)targetPath);
    }

    public void requestStaging(StagingContext ctx) {
        if (this.sourceArtifact != null) {
            this.logger.debug("[{}] is requesting staging of [{}]", (Object)this, (Object)this.sourceArtifact);
            this.stagedSourceArtifact = ctx.stageArtifact(this.sourceArtifact, (StagingTarget)this.container.getHost());
        } else {
            this.logger.debug("[{}] is not requesting artifact staging.", (Object)this);
        }
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        if (this.stagedSourceArtifact != null) {
            return this.doCopy(this.stagedSourceArtifact.get(this.getRemoteConnection(), this.getCtx()));
        }
        return this.doCopy(this.resolveSourceFile());
    }

    private StepExitCode doCopy(OverthereFile sourceFile) throws Exception {
        OverthereFile remoteFile;
        Preconditions.checkNotNull((Object)this.targetFileName);
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetPath);
        if (!remoteDir.exists()) {
            if (this.createTargetPath) {
                this.getCtx().logOutput("Creating path " + this.targetPath + " on host " + this.getContainer().getHost());
                remoteDir.mkdirs();
            } else if (sourceFile.isFile()) {
                this.getCtx().logError("Path " + this.targetPath + " on host " + this.getContainer().getHost() + " does not exist.");
                return StepExitCode.FAIL;
            }
        } else if (this.preserveExistingFiles) {
            this.getCtx().logOutput(remoteDir.getPath() + " already exists on host " + this.getContainer().getHost() + ". Leave it.");
            return StepExitCode.SUCCESS;
        }
        if (sourceFile.isDirectory()) {
            remoteFile = remoteDir;
        } else {
            remoteFile = remoteDir.getFile(this.getTargetFileName());
            if (remoteFile.exists() && !this.preserveExistingFiles) {
                this.getCtx().logOutput(remoteFile.getPath() + " already exists on host " + this.getContainer().getHost() + ". Will replace.");
                remoteFile.delete();
            }
        }
        this.getCtx().logOutput("Copying " + sourceFile.getPath() + " to " + remoteFile.getPath() + " on host " + this.getContainer().getHost());
        sourceFile.copyTo(remoteFile);
        return StepExitCode.SUCCESS;
    }

    protected OverthereFile resolveSourceFile() {
        Preconditions.checkNotNull((Object)this.sourceFile);
        return this.sourceFile;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return "Copy " + this.getSourceFileDescription() + " to " + this.getContainer().getHost();
        }
        return description;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public Artifact getSourceArtifact() {
        return this.sourceArtifact;
    }

    public void setSourceArtifact(Artifact sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isPreserveExistingFiles() {
        return this.preserveExistingFiles;
    }

    public void setPreserveExistingFiles(boolean preserveExistingFiles) {
        this.preserveExistingFiles = preserveExistingFiles;
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }
}

