package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.freemarker.BaseCiTemplateModel;

import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

public class CiTemplateModel extends BeanModel {

    private final BaseCiTemplateModel delegateModel;

    private static final String FILE_ATTRIBUTE = "file";
    public static final String MASKED_PASSWORD = "********";

    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    /**
     * @deprecated Use {@link #CiTemplateModel(ConfigurationItem, CiAwareObjectWrapper, boolean)} instead.
     */
    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        this(ci, wrapper, false);
    }

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper, boolean maskPasswords) {
        super(ci, wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        delegateModel = new BaseCiTemplateModel(ci, wrapper.getWrapper(), maskPasswords);
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals(FILE_ATTRIBUTE)) {
            if (ci instanceof SourceArtifact) {
                return handleSourceArtifact();
            } else if (ci instanceof DerivedArtifact) {
                return handleDerivedArtifact();
            }
        }
        return delegateModel.get(key);
    }

    private TemplateModel handleSourceArtifact() throws TemplateModelException {
        return uploadArtifactIfUploaderPresent(((SourceArtifact) ci));
    }

    private TemplateModel handleDerivedArtifact() throws TemplateModelException {
        return uploadArtifactIfUploaderPresent(((DerivedArtifact<?>) ci));
    }

    private TemplateModel uploadArtifactIfUploaderPresent(Artifact artifact) throws TemplateModelException {
        String path = artifact.getFile().getPath();
        if (wrapper.getUploader() != null) {
            path = wrapper.getUploader().upload(artifact);
        }
        return wrapper.wrap(path);
    }

    @Override
    public boolean isEmpty() {
        return delegateModel.isEmpty();
    }
}
