/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CiTemplateModel
extends BeanModel {
    private static final String FILE_ATTRIBUTE = "file";
    public static final String MASKED_PASSWORD = "********";
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;
    private boolean maskPasswords;

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        this(ci, wrapper, false);
    }

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper, boolean maskPasswords) {
        super((Object)ci, (BeansWrapper)wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        this.maskPasswords = maskPasswords;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        PropertyDescriptor pd;
        if (key.equals(FILE_ATTRIBUTE)) {
            if (this.ci instanceof SourceArtifact) {
                return this.handleSourceArtifact();
            }
            if (this.ci instanceof DerivedArtifact) {
                return this.handleDerivedArtifact();
            }
        }
        if ((pd = this.ci.getType().getDescriptor().getPropertyDescriptor(key)) == null) {
            return super.get(key);
        }
        return this.wrapper.wrap(this.extractValueFromCi(pd));
    }

    private Object extractValueFromCi(PropertyDescriptor pd) {
        HashMap ctx = Maps.newHashMap();
        if (this.ci instanceof AbstractDeployed) {
            ctx.put("deployed", this.ci);
        } else if (this.ci instanceof Container || this.ci instanceof NestedContainer) {
            ctx.put("container", this.ci);
        }
        if (pd.isPassword() && this.maskPasswords) {
            switch (pd.getKind()) {
                case SET_OF_STRING: {
                    return Sets.newHashSet((Object[])new String[]{MASKED_PASSWORD});
                }
                case LIST_OF_STRING: {
                    return Lists.newArrayList((Object[])new String[]{MASKED_PASSWORD});
                }
                case MAP_STRING_STRING: {
                    HashMap maskedMap = Maps.newHashMap();
                    maskedMap.put(MASKED_PASSWORD, MASKED_PASSWORD);
                    return maskedMap;
                }
            }
            return MASKED_PASSWORD;
        }
        switch (pd.getKind()) {
            case STRING: {
                return ConfigurationHolder.resolveExpression((String)pd.get(this.ci), (Object)ctx);
            }
            case SET_OF_STRING: {
                return ConfigurationHolder.resolveExpression((Set)pd.get(this.ci), (Object)ctx);
            }
            case LIST_OF_STRING: {
                return ConfigurationHolder.resolveExpression((List)pd.get(this.ci), (Object)ctx);
            }
            case MAP_STRING_STRING: {
                return ConfigurationHolder.resolveExpression((Map)pd.get(this.ci), ctx);
            }
        }
        return pd.get(this.ci);
    }

    private TemplateModel handleSourceArtifact() throws TemplateModelException {
        return this.uploadArtifactIfUploaderPresent((Artifact)((SourceArtifact)this.ci));
    }

    private TemplateModel handleDerivedArtifact() throws TemplateModelException {
        return this.uploadArtifactIfUploaderPresent((Artifact)((DerivedArtifact)this.ci));
    }

    private TemplateModel uploadArtifactIfUploaderPresent(Artifact artifact) throws TemplateModelException {
        String path = artifact.getFile().getPath();
        if (this.wrapper.getUploader() != null) {
            path = this.wrapper.getUploader().upload(artifact);
        }
        return this.wrapper.wrap(path);
    }

    public boolean isEmpty() {
        return false;
    }
}

