/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

public class WaitStep
implements Step {
    private static final int SECONDS_TO_SLEEP = 10;
    private int waitTimeInSeconds = 0;
    private int order;
    private String description;

    public WaitStep(int order, int waitTimeInSeconds, String container, String action) {
        this.waitTimeInSeconds = waitTimeInSeconds;
        this.order = order;
        this.description = "Waiting " + this.waitTimeInSeconds + " seconds for " + container + " to " + action;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public StepExitCode execute(ExecutionContext ctx) {
        int sleepIntervals = this.waitTimeInSeconds / 10;
        int remainingSeconds = this.waitTimeInSeconds % 10;
        ctx.logOutput(this.description);
        try {
            int secondsCountDown = this.waitTimeInSeconds;
            for (int i = 1; i <= sleepIntervals; ++i) {
                ctx.logOutput("Time remaining " + secondsCountDown + " seconds.");
                Thread.sleep(10000L);
                secondsCountDown -= 10;
            }
            if (remainingSeconds > 0) {
                ctx.logOutput("Time remaining " + remainingSeconds + " seconds.");
                Thread.sleep(remainingSeconds * 1000);
            }
            ctx.logOutput("Wait complete.");
        }
        catch (InterruptedException ignored) {
            ctx.logOutput("Wait interupted.");
            Thread.currentThread().interrupt();
        }
        return StepExitCode.SUCCESS;
    }
}

