/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseStep
implements Step {
    public static final String FREEMARKER_FILE_EXT = ".ftl";
    private String description;
    protected HostContainer container;
    private String remoteWorkingDirPath;
    private boolean retainRemoteWorkingDirOnCompletion;
    private transient OverthereConnection localConn;
    protected transient OverthereConnection remoteConn;
    protected transient ExecutionContext ctx;
    private transient OverthereFile remoteWorkingDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected BaseStep(String description, HostContainer container) {
        this.description = description;
        this.container = container;
    }

    protected BaseStep(HostContainer container) {
        this(null, container);
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode handleExecute(ExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            StepExitCode stepExitCode = this.doExecute();
            return stepExitCode;
        }
        finally {
            this.disconnect();
        }
    }

    protected abstract StepExitCode doExecute() throws Exception;

    protected ExecutionContext getCtx() {
        return this.ctx;
    }

    public HostContainer getContainer() {
        return this.container;
    }

    public OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) ? this.getRemoteConnection().getTempFile("generic_plugin", ".tmp") : this.getRemoteConnection().getFile(this.getRemoteWorkingDirPath());
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    public OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    public OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.getContainer().getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        if (this.localConn != null) {
            IOUtils.closeQuietly((Closeable)this.localConn);
        }
        if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) && !this.isRetainRemoteWorkingDirOnCompletion()) {
            this.getRemoteWorkingDirectory().deleteRecursively();
        }
        if (this.remoteConn != null) {
            IOUtils.closeQuietly((Closeable)this.remoteConn);
        }
        this.remoteWorkingDir = null;
        this.localConn = null;
        this.remoteConn = null;
    }

    public String getRemoteWorkingDirPath() {
        return this.remoteWorkingDirPath;
    }

    public void setRemoteWorkingDirPath(String remoteWorkingDirPath) {
        this.remoteWorkingDirPath = remoteWorkingDirPath;
    }

    public boolean isRetainRemoteWorkingDirOnCompletion() {
        return this.retainRemoteWorkingDirOnCompletion;
    }

    public void setRetainRemoteWorkingDirOnCompletion(boolean deleteWorkingDirOnCompletion) {
        this.retainRemoteWorkingDirOnCompletion = deleteWorkingDirOnCompletion;
    }

    protected OverthereFile uploadToWorkingDirectory(String content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(File content, String fileName) {
        String fileType = content.isDirectory() ? "directory" : "file";
        this.getCtx().logOutput("Uploading " + fileType + " " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        LocalFile.valueOf((File)content).copyTo(target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(URL content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OutputStream out = target.getOutputStream();
        try {
            Resources.copy((URL)content, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return target;
    }

    public boolean hostFileExists(String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        return file.exists();
    }

    public String getHostLineSeparator() {
        return this.getContainer().getHost().getOs().getLineSeparator();
    }

    public String getHostFileSeparator() {
        return this.getContainer().getHost().getOs().getFileSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readHostFile(String remoteFile) {
        String string;
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{remoteFile, this.getContainer().getHost()});
        InputStream in = file.getInputStream();
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            string = new String(bytes);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to read file " + remoteFile, (Throwable)e);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public String[] readHostFileLines(String remoteFile) {
        String data = this.readHostFile(remoteFile);
        Iterable iterable = Splitter.on((String)this.getHostLineSeparator()).split((CharSequence)data);
        return (String[])Iterables.toArray((Iterable)iterable, String.class);
    }

    public void createOrReplaceHostFile(String content, String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        Preconditions.checkNotNull((Object)content);
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        if (file.exists()) {
            this.logger.debug("File " + remoteFile + " already exists. Will delete before attempting to write.");
            file.delete();
        }
        if (!file.getParentFile().exists()) {
            this.logger.debug("Parent directory does not exist. Will create it.");
            file.getParentFile().mkdirs();
        }
        ByteArrayInputStream from = new ByteArrayInputStream(content.getBytes());
        OutputStream to = file.getOutputStream();
        try {
            ByteStreams.copy((InputStream)from, (OutputStream)to);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to write to " + remoteFile, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)from);
            IOUtils.closeQuietly((OutputStream)to);
        }
    }

    public NodeModel readHostXmlFileAsModel(String remoteXmlFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteXmlFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteXmlFile);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{remoteXmlFile, this.getContainer().getHost()});
        InputStream remoteXmlStream = file.getInputStream();
        try {
            NodeModel nodeModel = NodeModel.parse((InputSource)new InputSource(remoteXmlStream), (boolean)false, (boolean)true);
            return nodeModel;
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read xml file " + remoteXmlFile, exc);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read xml file " + remoteXmlFile, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot read xml file " + remoteXmlFile, (Throwable)exc);
        }
        finally {
            IOUtils.closeQuietly((InputStream)remoteXmlStream);
        }
    }

    public String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        return this.evaluateTemplate(templatePath, vars, false);
    }

    public String evaluateTemplate(String templatePath, Map<String, Object> vars, boolean maskPasswords) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            HashMap varsWithStatics = Maps.newHashMap(vars);
            varsWithStatics.put("step", this);
            varsWithStatics.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
            template.createProcessingEnvironment((Object)varsWithStatics, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper(this.createArtifactUploader(), maskPasswords)).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    protected ArtifactUploader createArtifactUploader() {
        return new ArtifactUploader(){

            @Override
            public String upload(Artifact file) {
                throw new UnsupportedOperationException("Artifact upload not supported in this step");
            }
        };
    }

    protected void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        OutputStream out = renderTo.getOutputStream();
        try {
            Template template = cfg.getTemplate(templatePath);
            template.process(vars, (Writer)new OutputStreamWriter(out));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public String resolveOsSpecificTemplate(String template) {
        if (this.classpathResourceExists(template + FREEMARKER_FILE_EXT)) {
            return template + FREEMARKER_FILE_EXT;
        }
        String osSpecificTemplate = template;
        String scriptExt = BaseStep.substringAfterLast(osSpecificTemplate, '.');
        if (scriptExt == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificTemplate = osSpecificTemplate + os.getScriptExtension();
        }
        if (!this.classpathResourceExists(osSpecificTemplate)) {
            String osSpecificScriptTemplate = osSpecificTemplate + FREEMARKER_FILE_EXT;
            if (!this.classpathResourceExists(osSpecificScriptTemplate)) {
                throw new IllegalArgumentException("Resource " + osSpecificTemplate + " not found in classpath");
            }
            osSpecificTemplate = osSpecificScriptTemplate;
        }
        return osSpecificTemplate;
    }

    public boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public static String substringAfterLast(String str, char sub, String defaultValue) {
        String s = BaseStep.substringAfterLast(str, sub);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public static String substringAfterLast(String str, char sub) {
        int pos = str.lastIndexOf(sub);
        if (pos == -1) {
            return null;
        }
        return str.substring(pos + 1);
    }
}

