/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.generic.freemarker.ArtifactUploader;
import com.xebialabs.deployit.plugin.generic.step.BaseStep;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseExecutionStep
extends BaseStep
implements PreviewStep,
StageableStep {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;
    private DerivedArtifact derivedArtifact;
    private StagedFile stagedDerivedArtifact;
    private File artifact;
    private List<File> fileResources = Lists.newArrayList();
    private List<String> classpathResources = Lists.newArrayList();
    private List<String> templateClasspathResources = Lists.newArrayList();
    private Preview preview;
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.generic.scripts");

    public BaseExecutionStep(String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(description, container);
        this.scriptTemplatePath = scriptPath;
        this.vars = Maps.newHashMap(vars);
        Preconditions.checkNotNull((Object)this.scriptTemplatePath);
    }

    public void requestStaging(StagingContext ctx) {
        if (this.derivedArtifact != null) {
            this.logger.debug("[{}] has requesting staging of [{}]", (Object)this, (Object)this.derivedArtifact);
            this.stagedDerivedArtifact = ctx.stageArtifact((Artifact)this.derivedArtifact, (StagingTarget)this.container.getHost());
        } else {
            this.logger.debug("[{}] has not requesting artifact staging.", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepExitCode doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            this.uploadArtifactIfPresent();
            this.uploadFileResources();
            this.uploadClasspathResources();
            this.uploadTemplateClasspathResources();
            OverthereFile executable = this.uploadScriptToExecute(this.scriptTemplatePath);
            this.setWorkingDirectory();
            StepExitCode stepExitCode = this.executeScript(executable);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preview getPreview() {
        if (this.preview == null) {
            this.ctx = new ExecutionContext(){

                public void logOutput(String output) {
                }

                public void logError(String error, Throwable t) {
                }

                public void logError(String error) {
                }

                public Object getAttribute(String name) {
                    throw new UnsupportedOperationException();
                }

                public void setAttribute(String name, Object value) {
                }

                public Repository getRepository() {
                    throw new UnsupportedOperationException();
                }

                public InspectionContext getInspectionContext() {
                    throw new UnsupportedOperationException();
                }
            };
            this.getLocalConnection();
            this.remoteConn = PreviewOverthereConnection.getPreviewConnection();
            try {
                String sourcePath = this.resolveOsSpecificTemplate(this.scriptTemplatePath);
                String contents = this.evaluateTemplate(sourcePath, this.vars, true);
                this.preview = Preview.withSourcePathAndContents((String)sourcePath, (String)contents);
            }
            finally {
                this.ctx = null;
                this.disconnect();
            }
        }
        return this.preview;
    }

    protected OverthereFile uploadArtifactIfPresent() {
        if (this.artifact != null) {
            return this.uploadToWorkingDirectory(this.artifact, this.artifact.getName());
        }
        return null;
    }

    protected void uploadFileResources() {
        for (File fileResource : this.fileResources) {
            this.uploadToWorkingDirectory(fileResource, fileResource.getName());
        }
    }

    protected void uploadClasspathResources() {
        for (String cpResource : this.classpathResources) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(cpResource);
            Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (String)"resource %s not found.", (Object[])new Object[]{cpResource});
            try {
                TFile file = new TFile(resource.toURI());
                this.uploadFileOrDirectory(this.getRemoteWorkingDirectory(), file, true);
            }
            catch (URISyntaxException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    protected void uploadFileOrDirectory(OverthereFile remoteDir, final TFile file, boolean logFileNameToConsole) throws IOException {
        if (file.isFile() && !file.isDirectory()) {
            if (logFileNameToConsole) {
                this.getCtx().logOutput("Uploading file " + file.getName() + " to working directory.");
            }
            final OverthereFile targetFile = remoteDir.getFile(file.getName());
            ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return new TFileInputStream((File)file);
                }
            }, (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return targetFile.getOutputStream();
                }
            });
        } else {
            OverthereFile targetDir;
            if (logFileNameToConsole) {
                this.getCtx().logOutput("Uploading directory " + file.getName() + " to working directory.");
            }
            if (!(targetDir = remoteDir.getFile(file.getName())).exists()) {
                targetDir.mkdir();
            }
            for (TFile childFile : file.listFiles(TArchiveDetector.NULL)) {
                this.uploadFileOrDirectory(targetDir, childFile, false);
            }
        }
    }

    protected void uploadTemplateClasspathResources() {
        for (String cpTemplate : this.templateClasspathResources) {
            this.uploadTemplateResourceToWorkingDirectory(cpTemplate);
        }
    }

    private OverthereFile uploadTemplateResourceToWorkingDirectory(String template) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(template);
        String content = this.evaluateTemplate(osSpecificTemplate, this.vars, false);
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        return this.uploadToWorkingDirectory(content, fileName);
    }

    protected OverthereFile uploadScriptToExecute(String scriptTemplatePath) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(scriptTemplatePath);
        String generatedScript = this.evaluateTemplate(osSpecificTemplate, this.vars, false);
        ScriptUtils.dumpScript((String)scriptTemplatePath, (String)generatedScript, (Logger)scriptsLogger);
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        return this.uploadToWorkingDirectory(generatedScript, fileName);
    }

    protected void setWorkingDirectory() {
        this.getRemoteConnection().setWorkingDirectory(this.getRemoteWorkingDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExitCode executeScript(OverthereFile executable) {
        executable.setExecutable(true);
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)this.getCtx());
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)this.getCtx());
        try {
            this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
            int rc = this.getRemoteConnection().execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, cmdLine);
            if (rc != 0) {
                this.getCtx().logError("Execution failed with return code " + rc);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stdoutHandler);
            IOUtils.closeQuietly((Closeable)stderrHandler);
        }
    }

    public String getScriptPath() {
        return this.scriptTemplatePath;
    }

    public List<File> getFileResources() {
        return this.fileResources;
    }

    public void setFileResources(List<File> fileResources) {
        this.fileResources = fileResources;
    }

    public List<String> getClasspathResources() {
        return this.classpathResources;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public List<String> getTemplateClasspathResources() {
        return this.templateClasspathResources;
    }

    public void setTemplateClasspathResources(List<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public void setArtifact(File artifact) {
        this.artifact = artifact;
    }

    public void setDerivedArtifact(DerivedArtifact da) {
        this.derivedArtifact = da;
    }

    public String getUploadedArtifactPath() {
        if (this.artifact != null) {
            return this.getRemoteWorkingDirectory().getPath() + this.getContainer().getHost().getOs().getFileSeparator() + this.artifact.getName();
        }
        return null;
    }

    protected String resolveOsSpecificFileName(String template) {
        return BaseExecutionStep.resolveOsSpecificFileName(template, this.getContainer());
    }

    public static String resolveOsSpecificFileName(String template, HostContainer hostContainer) {
        String fileExt;
        String osSpecificFile = BaseExecutionStep.substringAfterLast(template, '/', template);
        if (osSpecificFile.endsWith(".ftl")) {
            osSpecificFile = osSpecificFile.substring(0, osSpecificFile.lastIndexOf(".ftl"));
        }
        if ((fileExt = BaseExecutionStep.substringAfterLast(osSpecificFile, '.')) == null) {
            OperatingSystemFamily os = hostContainer.getHost().getOs();
            osSpecificFile = osSpecificFile + os.getScriptExtension();
        }
        return osSpecificFile;
    }

    @Override
    public ArtifactUploader createArtifactUploader() {
        return new WorkingFolderUploader(this.getCtx());
    }

    @VisibleForTesting
    public String getScriptTemplatePath() {
        return this.scriptTemplatePath;
    }

    @VisibleForTesting
    public Map<String, Object> getVars() {
        return this.vars;
    }

    private class WorkingFolderUploader
    implements ArtifactUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();
        private ExecutionContext ctx;

        public WorkingFolderUploader(ExecutionContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public String upload(Artifact artifact) {
            String path;
            if (this.uploadedFiles.containsKey(artifact.getName())) {
                return this.uploadedFiles.get(artifact.getName());
            }
            BaseExecutionStep.this.logger.trace("Requesting upload of artifact [{}]", (Object)artifact);
            BaseExecutionStep.this.logger.trace("Derived artifact = [{}]", (Object)BaseExecutionStep.this.derivedArtifact);
            if (artifact.getId().equals(BaseExecutionStep.this.derivedArtifact.getId()) && BaseExecutionStep.this.stagedDerivedArtifact != null) {
                BaseExecutionStep.this.logger.debug("Retrieving result of staging for artifact [{}]", (Object)BaseExecutionStep.this.derivedArtifact);
                path = BaseExecutionStep.this.stagedDerivedArtifact.get(BaseExecutionStep.this.getRemoteConnection(), this.ctx).getPath();
            } else {
                OverthereFile uploadedFile = BaseExecutionStep.this.getRemoteWorkingDirectory().getFile(artifact.getName());
                if (!uploadedFile.exists()) {
                    OverthereFile file = artifact.getFile();
                    String fileType = file.isDirectory() ? "directory" : "file";
                    this.ctx.logOutput("Uploading " + fileType + " " + artifact.getName() + " to working directory.");
                    file.copyTo(uploadedFile);
                } else {
                    BaseExecutionStep.this.logger.warn("Not uploading file " + artifact.getName() + " to working directory again because it has already been uploaded.");
                }
                path = uploadedFile.getPath();
            }
            this.uploadedFiles.put(artifact.getName(), path);
            return path;
        }
    }
}

