package com.xebialabs.deployit.plugin.generic.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.*;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;
import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder.resolveExpression;

public class ControlTaskDelegate {

    public static List<Step> dispatch(String name, Map<String,String> args, ConfigurationItem item, HostContainer container) {
        String script = args.get("script");
        if (isNullOrEmpty(script)) {  //backward compatibility
            String scriptPropertyName = name + "Script";
            Descriptor descriptor = DescriptorRegistry.getDescriptor(item.getType());
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(scriptPropertyName);
            checkArgument(propertyDescriptor!= null, "Control task script property %s not defined for CI type %s", scriptPropertyName, item.getType());
            script = (String) propertyDescriptor.get(item);
        }
        checkArgument(!isNullOrEmpty(script), "Argument 'script' is required.");

        Map<String, Object> thisVarContext = newHashMap();
        thisVarContext.put("container", container);
        if (item instanceof AbstractDeployed) {
            thisVarContext.put("deployed", item);
        }

        String scriptName = resolveExpression(script, thisVarContext);
        checkArgument(container instanceof HostContainer, "Control task '%s' with shell script '%s' can only be run against a container implementing remote.HostContainer. Container '%s' does not.", name, scriptName, container);
        String desc = "Executing " + name + " on " + item;
        return Collections.<Step>singletonList(new ScriptExecutionStep(1, scriptName, (HostContainer) container, thisVarContext, desc));
    }


}
