package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A template deployed to a generic container")
public class ProcessedTemplate<D extends Deployable> extends AbstractDeployedArtifact<D> {

	@Property(hidden = true, required = true, description = "Classpath to the freemarker template used to generate the content of the final text base artifact.")
	private String template;

	@Create
	public void executeCreate(DeploymentPlanningContext ctx) {
		ctx.addStep(createTemplateArtifactCopyStep());
	}

	@SuppressWarnings("unchecked")
    @Modify
	public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        ProcessedTemplate<D> previous = (ProcessedTemplate<D>) d.getPrevious();
		previous.executeDestroy(ctx);
		executeCreate(ctx);
	}

	@Destroy
	public void executeDestroy(DeploymentPlanningContext ctx) {
		ctx.addStep(createArtifactDeleteStep());
	}

    protected TemplateArtifactCopyStep createTemplateArtifactCopyStep() {
		TemplateArtifactCopyStep step = new TemplateArtifactCopyStep(getCreateOrder(), getContainer(), getDeployedAsFreeMarkerContext(), getTemplate(),
		        getTargetDirectory());
		step.setCreateTargetPath(isCreateTargetDirectory());
		step.setTargetFileName(resolveTargetFileName());
		step.setSourceFileDescription(getDeployable().getName());
		step.setDescription(getDescription(getCreateVerb()));
		return step;
	}

	protected ArtifactDeleteStep createArtifactDeleteStep() {
		ArtifactDeleteStep step = new ArtifactDeleteStep(getDestroyOrder(), getContainer(), getTargetDirectory());
		step.setTargetDirectoryShared(isTargetDirectoryShared());
		step.setTargetFile(resolveTargetFileName());
		step.setDescription(getDescription(getDestroyVerb()));
		return step;
	}

	public String getTemplate() {
		return resolveExpression(template);
	}

	public void setTemplate(String template) {
		this.template = template;
	}
}
