/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Set;

public class ArtifactDeleteStep
extends BaseDeploymentStep {
    private DeployableArtifact artifact;
    private String targetDirectory;
    private boolean targetDirectoryShared;
    private String targetFile;
    private String description;
    private Set<String> deleteAdditionalTargetFiles = Sets.newHashSet();

    public ArtifactDeleteStep(int n, HostContainer hostContainer, DeployableArtifact deployableArtifact, String string) {
        super(n, hostContainer);
        this.artifact = deployableArtifact;
        this.targetDirectory = (String)Preconditions.checkNotNull((Object)string);
    }

    public ArtifactDeleteStep(int n, HostContainer hostContainer, String string) {
        this(n, hostContainer, null, string);
    }

    @Override
    protected Step.Result doExecute() throws Exception {
        if (this.artifact != null) {
            this.deleteArtifact();
        } else {
            this.deleteTargetFile();
        }
        this.deleteAdditionalFiles(this.getDeleteAdditionalTargetFiles());
        return Step.Result.Success;
    }

    protected void deleteTargetFile() {
        OverthereFile overthereFile = this.getRemoteConnection().getFile(this.targetDirectory);
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            overthereFile = overthereFile.getFile(this.targetFile);
        }
        this.deleteFile(overthereFile);
    }

    protected void deleteAdditionalFiles(Set<String> set) {
        for (String string : set) {
            OverthereFile overthereFile = this.getRemoteConnection().getFile(string);
            if (overthereFile.exists()) {
                ((DeploymentExecutionContext)this.getCtx()).logOutput("Deleting " + overthereFile.getPath() + " on host " + this.getContainer().getHost());
                overthereFile.deleteRecursively();
                continue;
            }
            ((DeploymentExecutionContext)this.getCtx()).logOutput(overthereFile.getPath() + " does not exist on host " + this.getContainer().getHost() + ". Will not perform delete.");
        }
    }

    protected void deleteArtifact() {
        OverthereFile overthereFile = this.artifact.getFile();
        OverthereFile overthereFile2 = this.getRemoteConnection().getFile(this.targetDirectory);
        if (overthereFile.isDirectory()) {
            if (this.targetDirectoryShared) {
                for (OverthereFile overthereFile3 : overthereFile.listFiles()) {
                    this.deleteFile(overthereFile2.getFile(overthereFile3.getName()));
                }
            } else {
                this.deleteFile(overthereFile2);
            }
        } else {
            String string = Strings.nullToEmpty((String)this.targetFile).trim().isEmpty() ? this.artifact.getName() : this.targetFile;
            this.deleteFile(overthereFile2.getFile(string));
        }
    }

    protected void deleteFile(OverthereFile overthereFile) {
        ((DeploymentExecutionContext)this.getCtx()).logOutput("Deleting " + overthereFile.getPath() + " on host " + this.getContainer().getHost());
        if (overthereFile.exists()) {
            overthereFile.deleteRecursively();
        } else {
            ((DeploymentExecutionContext)this.getCtx()).logOutput("File " + overthereFile.getPath() + " was already gone from " + this.getContainer().getHost());
        }
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.generateDescription();
        }
        return this.description;
    }

    protected String generateDescription() {
        if (this.artifact != null) {
            return "Delete " + this.artifact.getName() + " from " + this.getContainer().getHost();
        }
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            return "Delete file " + this.targetFile + " from directory " + this.targetDirectory + " on host " + this.getContainer().getHost();
        }
        return "Delete directory " + this.targetDirectory + " from  " + this.getContainer().getHost();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String string) {
        this.targetFile = string;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean bl) {
        this.targetDirectoryShared = bl;
    }

    public Set<String> getDeleteAdditionalTargetFiles() {
        return this.deleteAdditionalTargetFiles;
    }

    public void setDeleteAdditionalTargetFiles(Set<String> set) {
        this.deleteAdditionalTargetFiles = set;
    }
}

