/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ClasspathTemplateLoader;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHolder {
    private static final AtomicReference<Configuration> holder = new AtomicReference();
    private static final String EXPRESSION_TOKEN = "${";
    private static final String EXPRESSION_IF_TOKEN = "<#if";
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationHolder.class);

    public static Configuration getConfiguration() {
        Configuration configuration = holder.get();
        if (configuration == null && !holder.compareAndSet(null, configuration = ConfigurationHolder.init())) {
            configuration = holder.get();
        }
        return configuration;
    }

    public static List<String> resolveExpression(List<String> arrayList, Object object) {
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
        }
        return Lists.newArrayList(ConfigurationHolder.transformCollectionByResolvingExpression(arrayList, object));
    }

    public static Set<String> resolveExpression(Set<String> hashSet, Object object) {
        if (hashSet == null) {
            hashSet = Sets.newHashSet();
        }
        return Sets.newHashSet(ConfigurationHolder.transformCollectionByResolvingExpression(hashSet, object));
    }

    private static Collection<String> transformCollectionByResolvingExpression(Collection<String> collection, final Object object) {
        return Collections2.transform(collection, (Function)new Function<String, String>(){

            public String apply(String string) {
                return ConfigurationHolder.resolveExpression(string, object);
            }
        });
    }

    public static Map<String, String> resolveExpression(Map<String, String> hashMap, Map<String, Object> map) {
        if (hashMap == null) {
            hashMap = Maps.newHashMap();
        }
        final HashMap hashMap2 = Maps.newHashMap(map);
        hashMap2.putAll(hashMap);
        return Maps.transformValues((Map)hashMap, (Function)new Function<String, String>(){

            public String apply(String string) {
                String string2 = string;
                while (ConfigurationHolder.isResolvable(string2)) {
                    string2 = ConfigurationHolder.resolveExpression(string2, (Object)hashMap2);
                }
                return string2;
            }
        });
    }

    public static String resolveExpression(String string, Object object) {
        if (!ConfigurationHolder.isResolvable(string)) {
            return string;
        }
        Configuration configuration = ConfigurationHolder.getConfiguration();
        try {
            logger.trace("Resolving expression {}.", (Object)string);
            Template template = new Template("expression", (Reader)new StringReader(string), configuration);
            StringWriter stringWriter = new StringWriter();
            template.process(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException);
        }
    }

    private static boolean isResolvable(String string) {
        return string != null && (string.contains(EXPRESSION_TOKEN) || string.contains(EXPRESSION_IF_TOKEN));
    }

    private static Configuration init() {
        Configuration configuration = new Configuration();
        configuration.setNumberFormat("computer");
        configuration.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader());
        configuration.setObjectWrapper((ObjectWrapper)new CiAwareObjectWrapper());
        return configuration;
    }
}

