/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.InspectScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="A container that is nested with another container")
public class NestedContainer
extends BaseContainer
implements GenericContainer {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("container", this);
    @Property(required=false, description="Environment variables for container", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the inspect script.")
    private Set<String> inspectClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the inspect script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> inspectTemplateClasspathResources = Sets.newHashSet();

    public Map<String, String> getEnvVars() {
        return ConfigurationHolder.resolveExpression(this.envVars, this.freeMarkerContext);
    }

    public void setEnvVars(Map<String, String> map) {
        this.envVars = map;
    }

    @Inspect
    public void inspectContainer(InspectionPlanningContext inspectionPlanningContext) {
        if (Strings.emptyToNull((String)this.getInspectScript()) != null) {
            InspectScriptExecutionStep inspectScriptExecutionStep = new InspectScriptExecutionStep((ConfigurationItem)this, this.getInspectScript(), (HostContainer)this.getHost(), this.freeMarkerContext, "Inspect " + this);
            inspectScriptExecutionStep.setTemplateClasspathResources(Lists.newArrayList(this.getInspectTemplateClasspathResources()));
            inspectScriptExecutionStep.setClasspathResources(Lists.newArrayList(this.getInspectClasspathResources()));
            inspectionPlanningContext.addStep((Step)inspectScriptExecutionStep);
        }
    }

    public List<Step> controlTaskDispatch(String string) {
        String string2 = string + "Script";
        PropertyDescriptor propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(string2);
        Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{string2, this.getType()});
        String string3 = ConfigurationHolder.resolveExpression((String)propertyDescriptor.get((ConfigurationItem)this), this.freeMarkerContext);
        return Collections.singletonList(new ScriptExecutionStep(1, string3, this, this.freeMarkerContext, "Executing " + string));
    }

    public Container getRootContainer() {
        Object t = this.getParentContainer();
        if (t instanceof Container) {
            return (Container)t;
        }
        if (t instanceof NestedContainer) {
            return ((NestedContainer)t).getRootContainer();
        }
        throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
    }

    @Override
    public <T extends GenericContainer> T getParentContainer() {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (!propertyDescriptor.isAsContainment()) continue;
            return (T)((GenericContainer)propertyDescriptor.get((ConfigurationItem)this));
        }
        throw new IllegalStateException("This nested container " + this.getType() + " does not have an asContainment relationship to another generic container.");
    }

    public Host getHost() {
        return this.getParentContainer().getHost();
    }

    public String getInspectScript() {
        return ConfigurationHolder.resolveExpression(this.inspectScript, this.freeMarkerContext);
    }

    public void setInspectScript(String string) {
        this.inspectScript = string;
    }

    public Set<String> getInspectClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectClasspathResources, this.freeMarkerContext);
    }

    public void setInspectClasspathResources(Set<String> set) {
        this.inspectClasspathResources = set;
    }

    public Set<String> getInspectTemplateClasspathResources() {
        return ConfigurationHolder.resolveExpression(this.inspectTemplateClasspathResources, this.freeMarkerContext);
    }

    public void setInspectTemplateClasspathResources(Set<String> set) {
        this.inspectTemplateClasspathResources = set;
    }
}

